/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListLaunchPathsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListLaunchPathsResponse> {
    private final List<LaunchPathSummary> launchPathSummaries;
    private final String nextPageToken;

    private ListLaunchPathsResponse(BuilderImpl builder) {
        super(builder);
        this.launchPathSummaries = builder.launchPathSummaries;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<LaunchPathSummary> launchPathSummaries() {
        return this.launchPathSummaries;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPathSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchPathsResponse)) {
            return false;
        }
        ListLaunchPathsResponse other = (ListLaunchPathsResponse)((Object)obj);
        return Objects.equals(this.launchPathSummaries(), other.launchPathSummaries()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLaunchPathsResponse").add("LaunchPathSummaries", this.launchPathSummaries()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchPathSummaries": {
                return Optional.of(clazz.cast(this.launchPathSummaries()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<LaunchPathSummary> launchPathSummaries;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchPathsResponse model) {
            this.launchPathSummaries(model.launchPathSummaries);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<LaunchPathSummary.Builder> getLaunchPathSummaries() {
            return this.launchPathSummaries != null ? (Collection)this.launchPathSummaries.stream().map(LaunchPathSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copy(launchPathSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPathSummaries(LaunchPathSummary ... launchPathSummaries) {
            this.launchPathSummaries(Arrays.asList(launchPathSummaries));
            return this;
        }

        public final void setLaunchPathSummaries(Collection<LaunchPathSummary.BuilderImpl> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copyFromBuilder(launchPathSummaries);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListLaunchPathsResponse build() {
            return new ListLaunchPathsResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, ListLaunchPathsResponse> {
        public Builder launchPathSummaries(Collection<LaunchPathSummary> var1);

        public Builder launchPathSummaries(LaunchPathSummary ... var1);

        public Builder nextPageToken(String var1);
    }
}

