/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.PrincipalType;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociatePrincipalWithPortfolioRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, AssociatePrincipalWithPortfolioRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final String principalARN;
    private final String principalType;

    private AssociatePrincipalWithPortfolioRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.principalARN = builder.principalARN;
        this.principalType = builder.principalType;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public String principalARN() {
        return this.principalARN;
    }

    public PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public String principalTypeString() {
        return this.principalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePrincipalWithPortfolioRequest)) {
            return false;
        }
        AssociatePrincipalWithPortfolioRequest other = (AssociatePrincipalWithPortfolioRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.principalARN(), other.principalARN()) && Objects.equals(this.principalTypeString(), other.principalTypeString());
    }

    public String toString() {
        return ToString.builder((String)"AssociatePrincipalWithPortfolioRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PortfolioId", (Object)this.portfolioId()).add("PrincipalARN", (Object)this.principalARN()).add("PrincipalType", (Object)this.principalTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.of(clazz.cast(this.portfolioId()));
            }
            case "PrincipalARN": {
                return Optional.of(clazz.cast(this.principalARN()));
            }
            case "PrincipalType": {
                return Optional.of(clazz.cast(this.principalTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private String principalARN;
        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePrincipalWithPortfolioRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.principalARN(model.principalARN);
            this.principalType(model.principalType);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getPrincipalARN() {
            return this.principalARN;
        }

        @Override
        public final Builder principalARN(String principalARN) {
            this.principalARN = principalARN;
            return this;
        }

        public final void setPrincipalARN(String principalARN) {
            this.principalARN = principalARN;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType.toString());
            return this;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssociatePrincipalWithPortfolioRequest build() {
            return new AssociatePrincipalWithPortfolioRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, AssociatePrincipalWithPortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder principalARN(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

