/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest;

@SdkInternalApi
public class CreateConstraintRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").build();
    private static final MarshallingInfo<String> PORTFOLIOID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PortfolioId").build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdempotencyToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final CreateConstraintRequestModelMarshaller INSTANCE = new CreateConstraintRequestModelMarshaller();

    public static CreateConstraintRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateConstraintRequest createConstraintRequest, ProtocolMarshaller protocolMarshaller) {
        if (createConstraintRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createConstraintRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)createConstraintRequest.portfolioId(), PORTFOLIOID_BINDING);
            protocolMarshaller.marshall((Object)createConstraintRequest.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)createConstraintRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)createConstraintRequest.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)createConstraintRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createConstraintRequest.idempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

