/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;

public final class ListPortfoliosPaginator
implements SdkIterable<ListPortfoliosResponse> {
    private final ServiceCatalogClient client;
    private final ListPortfoliosRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPortfoliosPaginator(ServiceCatalogClient client, ListPortfoliosRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPortfoliosResponseFetcher();
    }

    public Iterator<ListPortfoliosResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListPortfoliosResponseFetcher
    implements NextPageFetcher<ListPortfoliosResponse> {
        private ListPortfoliosResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListPortfoliosResponse nextPage(ListPortfoliosResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosPaginator.this.client.listPortfolios(ListPortfoliosPaginator.this.firstRequest);
            }
            return ListPortfoliosPaginator.this.client.listPortfolios((ListPortfoliosRequest)((Object)ListPortfoliosPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

