/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagKeysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdatePortfolioRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdatePortfolioRequest> {
    private final String acceptLanguage;
    private final String id;
    private final String displayName;
    private final String description;
    private final String providerName;
    private final List<Tag> addTags;
    private final List<String> removeTags;

    private UpdatePortfolioRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.providerName = builder.providerName;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String providerName() {
        return this.providerName;
    }

    public List<Tag> addTags() {
        return this.addTags;
    }

    public List<String> removeTags() {
        return this.removeTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeTags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortfolioRequest)) {
            return false;
        }
        UpdatePortfolioRequest other = (UpdatePortfolioRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.addTags(), other.addTags()) && Objects.equals(this.removeTags(), other.removeTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.addTags() != null) {
            sb.append("AddTags: ").append(this.addTags()).append(",");
        }
        if (this.removeTags() != null) {
            sb.append("RemoveTags: ").append(this.removeTags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ProviderName": {
                return Optional.of(clazz.cast(this.providerName()));
            }
            case "AddTags": {
                return Optional.of(clazz.cast(this.addTags()));
            }
            case "RemoveTags": {
                return Optional.of(clazz.cast(this.removeTags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String displayName;
        private String description;
        private String providerName;
        private List<Tag> addTags;
        private List<String> removeTags;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortfolioRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.id(model.id);
            this.displayName(model.displayName);
            this.description(model.description);
            this.providerName(model.providerName);
            this.addTags(model.addTags);
            this.removeTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Collection<Tag.Builder> getAddTags() {
            return this.addTags != null ? (Collection)this.addTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
            return this;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        public final Collection<String> getRemoveTags() {
            return this.removeTags;
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String ... removeTags) {
            this.removeTags(Arrays.asList(removeTags));
            return this;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        public UpdatePortfolioRequest build() {
            return new UpdatePortfolioRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdatePortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder providerName(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder removeTags(Collection<String> var1);

        public Builder removeTags(String ... var1);
    }
}

