/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.transform.PortfolioDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PortfolioDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, PortfolioDetail> {
    private final String id;
    private final String arn;
    private final String displayName;
    private final String description;
    private final Instant createdTime;
    private final String providerName;

    private PortfolioDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.providerName = builder.providerName;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String providerName() {
        return this.providerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortfolioDetail)) {
            return false;
        }
        PortfolioDetail other = (PortfolioDetail)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.providerName(), other.providerName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.arn() != null) {
            sb.append("ARN: ").append(this.arn()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "ProviderName": {
                return Optional.of(clazz.cast(this.providerName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortfolioDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String displayName;
        private String description;
        private Instant createdTime;
        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(PortfolioDetail model) {
            this.id(model.id);
            this.arn(model.arn);
            this.displayName(model.displayName);
            this.description(model.description);
            this.createdTime(model.createdTime);
            this.providerName(model.providerName);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public PortfolioDetail build() {
            return new PortfolioDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PortfolioDetail> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder createdTime(Instant var1);

        public Builder providerName(String var1);
    }
}

