/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsFilters;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListTagOptionsRequest> {
    private final ListTagOptionsFilters filters;
    private final Integer pageSize;
    private final String pageToken;

    private ListTagOptionsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public ListTagOptionsFilters filters() {
        return this.filters;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagOptionsRequest)) {
            return false;
        }
        ListTagOptionsRequest other = (ListTagOptionsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ListTagOptionsFilters filters;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagOptionsRequest model) {
            this.filters(model.filters);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final ListTagOptionsFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(ListTagOptionsFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(ListTagOptionsFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public ListTagOptionsRequest build() {
            return new ListTagOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagOptionsRequest> {
        public Builder filters(ListTagOptionsFilters var1);

        default public Builder filters(Consumer<ListTagOptionsFilters.Builder> filters) {
            return this.filters((ListTagOptionsFilters)((ListTagOptionsFilters.Builder)ListTagOptionsFilters.builder().apply(filters)).build());
        }

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);
    }
}

