/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ResourceDetail;
import software.amazon.awssdk.services.servicecatalog.model.ResourceDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourcesForTagOptionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListResourcesForTagOptionResponse> {
    private final List<ResourceDetail> resourceDetails;
    private final String pageToken;

    private ListResourcesForTagOptionResponse(BuilderImpl builder) {
        this.resourceDetails = builder.resourceDetails;
        this.pageToken = builder.pageToken;
    }

    public List<ResourceDetail> resourceDetails() {
        return this.resourceDetails;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForTagOptionResponse)) {
            return false;
        }
        ListResourcesForTagOptionResponse other = (ListResourcesForTagOptionResponse)((Object)obj);
        return Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceDetails() != null) {
            sb.append("ResourceDetails: ").append(this.resourceDetails()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceDetails": {
                return Optional.of(clazz.cast(this.resourceDetails()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourceDetail> resourceDetails;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForTagOptionResponse model) {
            this.resourceDetails(model.resourceDetails);
            this.pageToken(model.pageToken);
        }

        public final Collection<ResourceDetail.Builder> getResourceDetails() {
            return this.resourceDetails != null ? (Collection)this.resourceDetails.stream().map(ResourceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceDetails(Collection<ResourceDetail> resourceDetails) {
            this.resourceDetails = ResourceDetailsCopier.copy(resourceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDetails(ResourceDetail ... resourceDetails) {
            this.resourceDetails(Arrays.asList(resourceDetails));
            return this;
        }

        public final void setResourceDetails(Collection<ResourceDetail.BuilderImpl> resourceDetails) {
            this.resourceDetails = ResourceDetailsCopier.copyFromBuilder(resourceDetails);
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public ListResourcesForTagOptionResponse build() {
            return new ListResourcesForTagOptionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListResourcesForTagOptionResponse> {
        public Builder resourceDetails(Collection<ResourceDetail> var1);

        public Builder resourceDetails(ResourceDetail ... var1);

        public Builder pageToken(String var1);
    }
}

