/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFiltersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy;
import software.amazon.awssdk.services.servicecatalog.model.SortOrder;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchProductsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SearchProductsRequest> {
    private final String acceptLanguage;
    private final Map<String, List<String>> filters;
    private final Integer pageSize;
    private final String sortBy;
    private final String sortOrder;
    private final String pageToken;

    private SearchProductsRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.filters = builder.filters;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.pageToken = builder.pageToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public Map<ProductViewFilterBy, List<String>> filters() {
        return TypeConverter.convert(this.filters, ProductViewFilterBy::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)ProductViewFilterBy.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, List<String>> filtersStrings() {
        return this.filters;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public ProductViewSortBy sortBy() {
        return ProductViewSortBy.fromValue(this.sortBy);
    }

    public String sortByString() {
        return this.sortBy;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderString() {
        return this.sortOrder;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.filtersStrings() == null ? 0 : this.filtersStrings().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        hashCode = 31 * hashCode + (this.sortByString() == null ? 0 : this.sortByString().hashCode());
        hashCode = 31 * hashCode + (this.sortOrderString() == null ? 0 : this.sortOrderString().hashCode());
        hashCode = 31 * hashCode + (this.pageToken() == null ? 0 : this.pageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsRequest)) {
            return false;
        }
        SearchProductsRequest other = (SearchProductsRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.filtersStrings() == null ^ this.filtersStrings() == null) {
            return false;
        }
        if (other.filtersStrings() != null && !other.filtersStrings().equals(this.filtersStrings())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        if (other.pageSize() != null && !other.pageSize().equals(this.pageSize())) {
            return false;
        }
        if (other.sortByString() == null ^ this.sortByString() == null) {
            return false;
        }
        if (other.sortByString() != null && !other.sortByString().equals(this.sortByString())) {
            return false;
        }
        if (other.sortOrderString() == null ^ this.sortOrderString() == null) {
            return false;
        }
        if (other.sortOrderString() != null && !other.sortOrderString().equals(this.sortOrderString())) {
            return false;
        }
        if (other.pageToken() == null ^ this.pageToken() == null) {
            return false;
        }
        return other.pageToken() == null || other.pageToken().equals(this.pageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.filtersStrings() != null) {
            sb.append("Filters: ").append(this.filtersStrings()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.sortByString() != null) {
            sb.append("SortBy: ").append(this.sortByString()).append(",");
        }
        if (this.sortOrderString() != null) {
            sb.append("SortOrder: ").append(this.sortOrderString()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filtersStrings()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "SortBy": {
                return Optional.of(clazz.cast(this.sortByString()));
            }
            case "SortOrder": {
                return Optional.of(clazz.cast(this.sortOrderString()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private Map<String, List<String>> filters;
        private Integer pageSize;
        private String sortBy;
        private String sortOrder;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.filters(model.filters);
            this.pageSize(model.pageSize);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
            return this;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ProductViewSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public SearchProductsRequest build() {
            return new SearchProductsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchProductsRequest> {
        public Builder acceptLanguage(String var1);

        public Builder filters(Map<String, ? extends Collection<String>> var1);

        public Builder pageSize(Integer var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ProductViewSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder pageToken(String var1);
    }
}

