/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScanProvisionedProductsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ScanProvisionedProductsResponse> {
    private final List<ProvisionedProductDetail> provisionedProducts;
    private final String nextPageToken;

    private ScanProvisionedProductsResponse(BuilderImpl builder) {
        this.provisionedProducts = builder.provisionedProducts;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProvisionedProductDetail> provisionedProducts() {
        return this.provisionedProducts;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.provisionedProducts() == null ? 0 : this.provisionedProducts().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanProvisionedProductsResponse)) {
            return false;
        }
        ScanProvisionedProductsResponse other = (ScanProvisionedProductsResponse)((Object)obj);
        if (other.provisionedProducts() == null ^ this.provisionedProducts() == null) {
            return false;
        }
        if (other.provisionedProducts() != null && !other.provisionedProducts().equals(this.provisionedProducts())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.provisionedProducts() != null) {
            sb.append("ProvisionedProducts: ").append(this.provisionedProducts()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProducts": {
                return Optional.of(clazz.cast(this.provisionedProducts()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ProvisionedProductDetail> provisionedProducts;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanProvisionedProductsResponse model) {
            this.provisionedProducts(model.provisionedProducts);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisionedProductDetail.Builder> getProvisionedProducts() {
            return this.provisionedProducts != null ? (Collection)this.provisionedProducts.stream().map(ProvisionedProductDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedProducts(Collection<ProvisionedProductDetail> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductDetailsCopier.copy(provisionedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(ProvisionedProductDetail ... provisionedProducts) {
            this.provisionedProducts(Arrays.asList(provisionedProducts));
            return this;
        }

        public final void setProvisionedProducts(Collection<ProvisionedProductDetail.BuilderImpl> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductDetailsCopier.copyFromBuilder(provisionedProducts);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ScanProvisionedProductsResponse build() {
            return new ScanProvisionedProductsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScanProvisionedProductsResponse> {
        public Builder provisionedProducts(Collection<ProvisionedProductDetail> var1);

        public Builder provisionedProducts(ProvisionedProductDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

