/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.transform.RecordOutputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordOutput
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordOutput> {
    private final String outputKey;
    private final String outputValue;
    private final String description;

    private RecordOutput(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
    }

    public String outputKey() {
        return this.outputKey;
    }

    public String outputValue() {
        return this.outputValue;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputKey() == null ? 0 : this.outputKey().hashCode());
        hashCode = 31 * hashCode + (this.outputValue() == null ? 0 : this.outputValue().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordOutput)) {
            return false;
        }
        RecordOutput other = (RecordOutput)obj;
        if (other.outputKey() == null ^ this.outputKey() == null) {
            return false;
        }
        if (other.outputKey() != null && !other.outputKey().equals(this.outputKey())) {
            return false;
        }
        if (other.outputValue() == null ^ this.outputValue() == null) {
            return false;
        }
        if (other.outputValue() != null && !other.outputValue().equals(this.outputValue())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.outputKey() != null) {
            sb.append("OutputKey: ").append(this.outputKey()).append(",");
        }
        if (this.outputValue() != null) {
            sb.append("OutputValue: ").append(this.outputValue()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputKey": {
                return Optional.of(clazz.cast(this.outputKey()));
            }
            case "OutputValue": {
                return Optional.of(clazz.cast(this.outputValue()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputKey;
        private String outputValue;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordOutput model) {
            this.outputKey(model.outputKey);
            this.outputValue(model.outputValue);
            this.description(model.description);
        }

        public final String getOutputKey() {
            return this.outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return this.outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public RecordOutput build() {
            return new RecordOutput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordOutput> {
        public Builder outputKey(String var1);

        public Builder outputValue(String var1);

        public Builder description(String var1);
    }
}

