/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisassociatePrincipalFromPortfolioRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DisassociatePrincipalFromPortfolioRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final String principalARN;

    private DisassociatePrincipalFromPortfolioRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.principalARN = builder.principalARN;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public String principalARN() {
        return this.principalARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.portfolioId() == null ? 0 : this.portfolioId().hashCode());
        hashCode = 31 * hashCode + (this.principalARN() == null ? 0 : this.principalARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociatePrincipalFromPortfolioRequest)) {
            return false;
        }
        DisassociatePrincipalFromPortfolioRequest other = (DisassociatePrincipalFromPortfolioRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.portfolioId() == null ^ this.portfolioId() == null) {
            return false;
        }
        if (other.portfolioId() != null && !other.portfolioId().equals(this.portfolioId())) {
            return false;
        }
        if (other.principalARN() == null ^ this.principalARN() == null) {
            return false;
        }
        return other.principalARN() == null || other.principalARN().equals(this.principalARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.portfolioId() != null) {
            sb.append("PortfolioId: ").append(this.portfolioId()).append(",");
        }
        if (this.principalARN() != null) {
            sb.append("PrincipalARN: ").append(this.principalARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.of(clazz.cast(this.portfolioId()));
            }
            case "PrincipalARN": {
                return Optional.of(clazz.cast(this.principalARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private String principalARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociatePrincipalFromPortfolioRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.principalARN(model.principalARN);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getPrincipalARN() {
            return this.principalARN;
        }

        @Override
        public final Builder principalARN(String principalARN) {
            this.principalARN = principalARN;
            return this;
        }

        public final void setPrincipalARN(String principalARN) {
            this.principalARN = principalARN;
        }

        public DisassociatePrincipalFromPortfolioRequest build() {
            return new DisassociatePrincipalFromPortfolioRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisassociatePrincipalFromPortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder principalARN(String var1);
    }
}

