/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePortfolioResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePortfolioResponse> {
    private final PortfolioDetail portfolioDetail;
    private final List<Tag> tags;

    private DescribePortfolioResponse(BuilderImpl builder) {
        this.portfolioDetail = builder.portfolioDetail;
        this.tags = builder.tags;
    }

    public PortfolioDetail portfolioDetail() {
        return this.portfolioDetail;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.portfolioDetail() == null ? 0 : this.portfolioDetail().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioResponse)) {
            return false;
        }
        DescribePortfolioResponse other = (DescribePortfolioResponse)((Object)obj);
        if (other.portfolioDetail() == null ^ this.portfolioDetail() == null) {
            return false;
        }
        if (other.portfolioDetail() != null && !other.portfolioDetail().equals(this.portfolioDetail())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.portfolioDetail() != null) {
            sb.append("PortfolioDetail: ").append(this.portfolioDetail()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioDetail": {
                return Optional.of(clazz.cast(this.portfolioDetail()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private PortfolioDetail portfolioDetail;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioResponse model) {
            this.portfolioDetail(model.portfolioDetail);
            this.tags(model.tags);
        }

        public final PortfolioDetail.Builder getPortfolioDetail() {
            return this.portfolioDetail != null ? this.portfolioDetail.toBuilder() : null;
        }

        @Override
        public final Builder portfolioDetail(PortfolioDetail portfolioDetail) {
            this.portfolioDetail = portfolioDetail;
            return this;
        }

        public final void setPortfolioDetail(PortfolioDetail.BuilderImpl portfolioDetail) {
            this.portfolioDetail = portfolioDetail != null ? portfolioDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public DescribePortfolioResponse build() {
            return new DescribePortfolioResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePortfolioResponse> {
        public Builder portfolioDetail(PortfolioDetail var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

