/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;

@SdkInternalApi
public class ProductViewSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<String> SHORTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShortDescription").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> DISTRIBUTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Distributor").build();
    private static final MarshallingInfo<Boolean> HASDEFAULTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasDefaultPath").build();
    private static final MarshallingInfo<String> SUPPORTEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportEmail").build();
    private static final MarshallingInfo<String> SUPPORTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportDescription").build();
    private static final MarshallingInfo<String> SUPPORTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportUrl").build();
    private static final ProductViewSummaryMarshaller INSTANCE = new ProductViewSummaryMarshaller();

    public static ProductViewSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProductViewSummary productViewSummary, ProtocolMarshaller protocolMarshaller) {
        if (productViewSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)productViewSummary.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.shortDescription(), SHORTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.distributor(), DISTRIBUTOR_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.hasDefaultPath(), HASDEFAULTPATH_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.supportEmail(), SUPPORTEMAIL_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.supportDescription(), SUPPORTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.supportUrl(), SUPPORTURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

