/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.UsageInstruction;
import software.amazon.awssdk.services.servicecatalog.model.UsageInstructionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeProvisioningParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
    private final List<ProvisioningArtifactParameter> provisioningArtifactParameters;
    private final List<ConstraintSummary> constraintSummaries;
    private final List<UsageInstruction> usageInstructions;

    private DescribeProvisioningParametersResponse(BuilderImpl builder) {
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.constraintSummaries = builder.constraintSummaries;
        this.usageInstructions = builder.usageInstructions;
    }

    public List<ProvisioningArtifactParameter> provisioningArtifactParameters() {
        return this.provisioningArtifactParameters;
    }

    public List<ConstraintSummary> constraintSummaries() {
        return this.constraintSummaries;
    }

    public List<UsageInstruction> usageInstructions() {
        return this.usageInstructions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.provisioningArtifactParameters() == null ? 0 : this.provisioningArtifactParameters().hashCode());
        hashCode = 31 * hashCode + (this.constraintSummaries() == null ? 0 : this.constraintSummaries().hashCode());
        hashCode = 31 * hashCode + (this.usageInstructions() == null ? 0 : this.usageInstructions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersResponse)) {
            return false;
        }
        DescribeProvisioningParametersResponse other = (DescribeProvisioningParametersResponse)((Object)obj);
        if (other.provisioningArtifactParameters() == null ^ this.provisioningArtifactParameters() == null) {
            return false;
        }
        if (other.provisioningArtifactParameters() != null && !other.provisioningArtifactParameters().equals(this.provisioningArtifactParameters())) {
            return false;
        }
        if (other.constraintSummaries() == null ^ this.constraintSummaries() == null) {
            return false;
        }
        if (other.constraintSummaries() != null && !other.constraintSummaries().equals(this.constraintSummaries())) {
            return false;
        }
        if (other.usageInstructions() == null ^ this.usageInstructions() == null) {
            return false;
        }
        return other.usageInstructions() == null || other.usageInstructions().equals(this.usageInstructions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.provisioningArtifactParameters() != null) {
            sb.append("ProvisioningArtifactParameters: ").append(this.provisioningArtifactParameters()).append(",");
        }
        if (this.constraintSummaries() != null) {
            sb.append("ConstraintSummaries: ").append(this.constraintSummaries()).append(",");
        }
        if (this.usageInstructions() != null) {
            sb.append("UsageInstructions: ").append(this.usageInstructions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ProvisioningArtifactParameter> provisioningArtifactParameters;
        private List<ConstraintSummary> constraintSummaries;
        private List<UsageInstruction> usageInstructions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersResponse model) {
            this.setProvisioningArtifactParameters(model.provisioningArtifactParameters);
            this.setConstraintSummaries(model.constraintSummaries);
            this.setUsageInstructions(model.usageInstructions);
        }

        public final Collection<ProvisioningArtifactParameter> getProvisioningArtifactParameters() {
            return this.provisioningArtifactParameters;
        }

        @Override
        public final Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copy(provisioningArtifactParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(ProvisioningArtifactParameter ... provisioningArtifactParameters) {
            this.provisioningArtifactParameters(Arrays.asList(provisioningArtifactParameters));
            return this;
        }

        public final void setProvisioningArtifactParameters(Collection<ProvisioningArtifactParameter> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copy(provisioningArtifactParameters);
        }

        public final Collection<ConstraintSummary> getConstraintSummaries() {
            return this.constraintSummaries;
        }

        @Override
        public final Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(ConstraintSummary ... constraintSummaries) {
            this.constraintSummaries(Arrays.asList(constraintSummaries));
            return this;
        }

        public final void setConstraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
        }

        public final Collection<UsageInstruction> getUsageInstructions() {
            return this.usageInstructions;
        }

        @Override
        public final Builder usageInstructions(Collection<UsageInstruction> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copy(usageInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(UsageInstruction ... usageInstructions) {
            this.usageInstructions(Arrays.asList(usageInstructions));
            return this;
        }

        public final void setUsageInstructions(Collection<UsageInstruction> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copy(usageInstructions);
        }

        public DescribeProvisioningParametersResponse build() {
            return new DescribeProvisioningParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
        public Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> var1);

        public Builder provisioningArtifactParameters(ProvisioningArtifactParameter ... var1);

        public Builder constraintSummaries(Collection<ConstraintSummary> var1);

        public Builder constraintSummaries(ConstraintSummary ... var1);

        public Builder usageInstructions(Collection<UsageInstruction> var1);

        public Builder usageInstructions(UsageInstruction ... var1);
    }
}

