/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchProductsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SearchProductsResponse> {
    private final List<ProductViewSummary> productViewSummaries;
    private final Map<String, List<ProductViewAggregationValue>> productViewAggregations;
    private final String nextPageToken;

    private SearchProductsResponse(BuilderImpl builder) {
        this.productViewSummaries = builder.productViewSummaries;
        this.productViewAggregations = builder.productViewAggregations;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProductViewSummary> productViewSummaries() {
        return this.productViewSummaries;
    }

    public Map<String, List<ProductViewAggregationValue>> productViewAggregations() {
        return this.productViewAggregations;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.productViewSummaries() == null ? 0 : this.productViewSummaries().hashCode());
        hashCode = 31 * hashCode + (this.productViewAggregations() == null ? 0 : this.productViewAggregations().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsResponse)) {
            return false;
        }
        SearchProductsResponse other = (SearchProductsResponse)((Object)obj);
        if (other.productViewSummaries() == null ^ this.productViewSummaries() == null) {
            return false;
        }
        if (other.productViewSummaries() != null && !other.productViewSummaries().equals(this.productViewSummaries())) {
            return false;
        }
        if (other.productViewAggregations() == null ^ this.productViewAggregations() == null) {
            return false;
        }
        if (other.productViewAggregations() != null && !other.productViewAggregations().equals(this.productViewAggregations())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.productViewSummaries() != null) {
            sb.append("ProductViewSummaries: ").append(this.productViewSummaries()).append(",");
        }
        if (this.productViewAggregations() != null) {
            sb.append("ProductViewAggregations: ").append(this.productViewAggregations()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ProductViewSummary> productViewSummaries;
        private Map<String, List<ProductViewAggregationValue>> productViewAggregations;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsResponse model) {
            this.setProductViewSummaries(model.productViewSummaries);
            this.setProductViewAggregations(model.productViewAggregations);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewSummary> getProductViewSummaries() {
            return this.productViewSummaries;
        }

        @Override
        public final Builder productViewSummaries(Collection<ProductViewSummary> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copy(productViewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewSummaries(ProductViewSummary ... productViewSummaries) {
            this.productViewSummaries(Arrays.asList(productViewSummaries));
            return this;
        }

        public final void setProductViewSummaries(Collection<ProductViewSummary> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copy(productViewSummaries);
        }

        @SafeVarargs
        public final void setProductViewSummaries(ProductViewSummary ... productViewSummaries) {
            this.productViewSummaries(Arrays.asList(productViewSummaries));
        }

        public final Map<String, ? extends Collection<ProductViewAggregationValue>> getProductViewAggregations() {
            return this.productViewAggregations;
        }

        @Override
        public final Builder productViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
            return this;
        }

        public final void setProductViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public SearchProductsResponse build() {
            return new SearchProductsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchProductsResponse> {
        public Builder productViewSummaries(Collection<ProductViewSummary> var1);

        public Builder productViewSummaries(ProductViewSummary ... var1);

        public Builder productViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> var1);

        public Builder nextPageToken(String var1);
    }
}

