/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RejectPortfolioShareRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, RejectPortfolioShareRequest> {
    private final String acceptLanguage;
    private final String portfolioId;

    private RejectPortfolioShareRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectPortfolioShareRequest)) {
            return false;
        }
        RejectPortfolioShareRequest other = (RejectPortfolioShareRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId());
    }

    public String toString() {
        return ToString.builder((String)"RejectPortfolioShareRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PortfolioId", (Object)this.portfolioId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.of(clazz.cast(this.portfolioId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectPortfolioShareRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RejectPortfolioShareRequest build() {
            return new RejectPortfolioShareRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, RejectPortfolioShareRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

