/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisassociatePrincipalFromPortfolioRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DisassociatePrincipalFromPortfolioRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final String principalARN;

    private DisassociatePrincipalFromPortfolioRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.principalARN = builder.principalARN;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public String principalARN() {
        return this.principalARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociatePrincipalFromPortfolioRequest)) {
            return false;
        }
        DisassociatePrincipalFromPortfolioRequest other = (DisassociatePrincipalFromPortfolioRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.principalARN(), other.principalARN());
    }

    public String toString() {
        return ToString.builder((String)"DisassociatePrincipalFromPortfolioRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PortfolioId", (Object)this.portfolioId()).add("PrincipalARN", (Object)this.principalARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.of(clazz.cast(this.portfolioId()));
            }
            case "PrincipalARN": {
                return Optional.of(clazz.cast(this.principalARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private String principalARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociatePrincipalFromPortfolioRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.principalARN(model.principalARN);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getPrincipalARN() {
            return this.principalARN;
        }

        @Override
        public final Builder principalARN(String principalARN) {
            this.principalARN = principalARN;
            return this;
        }

        public final void setPrincipalARN(String principalARN) {
            this.principalARN = principalARN;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DisassociatePrincipalFromPortfolioRequest build() {
            return new DisassociatePrincipalFromPortfolioRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, DisassociatePrincipalFromPortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder principalARN(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

