/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagKeysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateProductRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateProductRequest> {
    private final String acceptLanguage;
    private final String id;
    private final String name;
    private final String owner;
    private final String description;
    private final String distributor;
    private final String supportDescription;
    private final String supportEmail;
    private final String supportUrl;
    private final List<Tag> addTags;
    private final List<String> removeTags;

    private UpdateProductRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public String description() {
        return this.description;
    }

    public String distributor() {
        return this.distributor;
    }

    public String supportDescription() {
        return this.supportDescription;
    }

    public String supportEmail() {
        return this.supportEmail;
    }

    public String supportUrl() {
        return this.supportUrl;
    }

    public List<Tag> addTags() {
        return this.addTags;
    }

    public List<String> removeTags() {
        return this.removeTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.distributor() == null ? 0 : this.distributor().hashCode());
        hashCode = 31 * hashCode + (this.supportDescription() == null ? 0 : this.supportDescription().hashCode());
        hashCode = 31 * hashCode + (this.supportEmail() == null ? 0 : this.supportEmail().hashCode());
        hashCode = 31 * hashCode + (this.supportUrl() == null ? 0 : this.supportUrl().hashCode());
        hashCode = 31 * hashCode + (this.addTags() == null ? 0 : this.addTags().hashCode());
        hashCode = 31 * hashCode + (this.removeTags() == null ? 0 : this.removeTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductRequest)) {
            return false;
        }
        UpdateProductRequest other = (UpdateProductRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.distributor() == null ^ this.distributor() == null) {
            return false;
        }
        if (other.distributor() != null && !other.distributor().equals(this.distributor())) {
            return false;
        }
        if (other.supportDescription() == null ^ this.supportDescription() == null) {
            return false;
        }
        if (other.supportDescription() != null && !other.supportDescription().equals(this.supportDescription())) {
            return false;
        }
        if (other.supportEmail() == null ^ this.supportEmail() == null) {
            return false;
        }
        if (other.supportEmail() != null && !other.supportEmail().equals(this.supportEmail())) {
            return false;
        }
        if (other.supportUrl() == null ^ this.supportUrl() == null) {
            return false;
        }
        if (other.supportUrl() != null && !other.supportUrl().equals(this.supportUrl())) {
            return false;
        }
        if (other.addTags() == null ^ this.addTags() == null) {
            return false;
        }
        if (other.addTags() != null && !other.addTags().equals(this.addTags())) {
            return false;
        }
        if (other.removeTags() == null ^ this.removeTags() == null) {
            return false;
        }
        return other.removeTags() == null || other.removeTags().equals(this.removeTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.distributor() != null) {
            sb.append("Distributor: ").append(this.distributor()).append(",");
        }
        if (this.supportDescription() != null) {
            sb.append("SupportDescription: ").append(this.supportDescription()).append(",");
        }
        if (this.supportEmail() != null) {
            sb.append("SupportEmail: ").append(this.supportEmail()).append(",");
        }
        if (this.supportUrl() != null) {
            sb.append("SupportUrl: ").append(this.supportUrl()).append(",");
        }
        if (this.addTags() != null) {
            sb.append("AddTags: ").append(this.addTags()).append(",");
        }
        if (this.removeTags() != null) {
            sb.append("RemoveTags: ").append(this.removeTags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String name;
        private String owner;
        private String description;
        private String distributor;
        private String supportDescription;
        private String supportEmail;
        private String supportUrl;
        private List<Tag> addTags;
        private List<String> removeTags;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setId(model.id);
            this.setName(model.name);
            this.setOwner(model.owner);
            this.setDescription(model.description);
            this.setDistributor(model.distributor);
            this.setSupportDescription(model.supportDescription);
            this.setSupportEmail(model.supportEmail);
            this.setSupportUrl(model.supportUrl);
            this.setAddTags(model.addTags);
            this.setRemoveTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDistributor() {
            return this.distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        public final String getSupportDescription() {
            return this.supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        public final String getSupportUrl() {
            return this.supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public final Collection<Tag> getAddTags() {
            return this.addTags;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            if (this.addTags == null) {
                this.addTags = new ArrayList<Tag>(addTags.length);
            }
            for (Tag e : addTags) {
                this.addTags.add(e);
            }
            return this;
        }

        public final void setAddTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
        }

        @SafeVarargs
        public final void setAddTags(Tag ... addTags) {
            if (this.addTags == null) {
                this.addTags = new ArrayList<Tag>(addTags.length);
            }
            for (Tag e : addTags) {
                this.addTags.add(e);
            }
        }

        public final Collection<String> getRemoveTags() {
            return this.removeTags;
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String ... removeTags) {
            if (this.removeTags == null) {
                this.removeTags = new ArrayList<String>(removeTags.length);
            }
            for (String e : removeTags) {
                this.removeTags.add(e);
            }
            return this;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @SafeVarargs
        public final void setRemoveTags(String ... removeTags) {
            if (this.removeTags == null) {
                this.removeTags = new ArrayList<String>(removeTags.length);
            }
            for (String e : removeTags) {
                this.removeTags.add(e);
            }
        }

        public UpdateProductRequest build() {
            return new UpdateProductRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder distributor(String var1);

        public Builder supportDescription(String var1);

        public Builder supportEmail(String var1);

        public Builder supportUrl(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder removeTags(Collection<String> var1);

        public Builder removeTags(String ... var1);
    }
}

