/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagKeysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdatePortfolioRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdatePortfolioRequest> {
    private final String acceptLanguage;
    private final String id;
    private final String displayName;
    private final String description;
    private final String providerName;
    private final List<Tag> addTags;
    private final List<String> removeTags;

    private UpdatePortfolioRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.providerName = builder.providerName;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String providerName() {
        return this.providerName;
    }

    public List<Tag> addTags() {
        return this.addTags;
    }

    public List<String> removeTags() {
        return this.removeTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.providerName() == null ? 0 : this.providerName().hashCode());
        hashCode = 31 * hashCode + (this.addTags() == null ? 0 : this.addTags().hashCode());
        hashCode = 31 * hashCode + (this.removeTags() == null ? 0 : this.removeTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortfolioRequest)) {
            return false;
        }
        UpdatePortfolioRequest other = (UpdatePortfolioRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.providerName() == null ^ this.providerName() == null) {
            return false;
        }
        if (other.providerName() != null && !other.providerName().equals(this.providerName())) {
            return false;
        }
        if (other.addTags() == null ^ this.addTags() == null) {
            return false;
        }
        if (other.addTags() != null && !other.addTags().equals(this.addTags())) {
            return false;
        }
        if (other.removeTags() == null ^ this.removeTags() == null) {
            return false;
        }
        return other.removeTags() == null || other.removeTags().equals(this.removeTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.addTags() != null) {
            sb.append("AddTags: ").append(this.addTags()).append(",");
        }
        if (this.removeTags() != null) {
            sb.append("RemoveTags: ").append(this.removeTags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String displayName;
        private String description;
        private String providerName;
        private List<Tag> addTags;
        private List<String> removeTags;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortfolioRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setId(model.id);
            this.setDisplayName(model.displayName);
            this.setDescription(model.description);
            this.setProviderName(model.providerName);
            this.setAddTags(model.addTags);
            this.setRemoveTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Collection<Tag> getAddTags() {
            return this.addTags;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            if (this.addTags == null) {
                this.addTags = new ArrayList<Tag>(addTags.length);
            }
            for (Tag e : addTags) {
                this.addTags.add(e);
            }
            return this;
        }

        public final void setAddTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
        }

        @SafeVarargs
        public final void setAddTags(Tag ... addTags) {
            if (this.addTags == null) {
                this.addTags = new ArrayList<Tag>(addTags.length);
            }
            for (Tag e : addTags) {
                this.addTags.add(e);
            }
        }

        public final Collection<String> getRemoveTags() {
            return this.removeTags;
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String ... removeTags) {
            if (this.removeTags == null) {
                this.removeTags = new ArrayList<String>(removeTags.length);
            }
            for (String e : removeTags) {
                this.removeTags.add(e);
            }
            return this;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @SafeVarargs
        public final void setRemoveTags(String ... removeTags) {
            if (this.removeTags == null) {
                this.removeTags = new ArrayList<String>(removeTags.length);
            }
            for (String e : removeTags) {
                this.removeTags.add(e);
            }
        }

        public UpdatePortfolioRequest build() {
            return new UpdatePortfolioRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdatePortfolioRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder providerName(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder removeTags(Collection<String> var1);

        public Builder removeTags(String ... var1);
    }
}

