/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Date;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactInfoCopier;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisioningArtifactSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisioningArtifactSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisioningArtifactSummary> {
    private final String id;
    private final String name;
    private final String description;
    private final Date createdTime;
    private final Map<String, String> provisioningArtifactMetadata;

    private ProvisioningArtifactSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.provisioningArtifactMetadata = builder.provisioningArtifactMetadata;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Date createdTime() {
        return this.createdTime;
    }

    public Map<String, String> provisioningArtifactMetadata() {
        return this.provisioningArtifactMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.provisioningArtifactMetadata() == null ? 0 : this.provisioningArtifactMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactSummary)) {
            return false;
        }
        ProvisioningArtifactSummary other = (ProvisioningArtifactSummary)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.provisioningArtifactMetadata() == null ^ this.provisioningArtifactMetadata() == null) {
            return false;
        }
        return other.provisioningArtifactMetadata() == null || other.provisioningArtifactMetadata().equals(this.provisioningArtifactMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.provisioningArtifactMetadata() != null) {
            sb.append("ProvisioningArtifactMetadata: ").append(this.provisioningArtifactMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisioningArtifactSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private Date createdTime;
        private Map<String, String> provisioningArtifactMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactSummary model) {
            this.setId(model.id);
            this.setName(model.name);
            this.setDescription(model.description);
            this.setCreatedTime(model.createdTime);
            this.setProvisioningArtifactMetadata(model.provisioningArtifactMetadata);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Date getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy((Date)createdTime);
            return this;
        }

        public final void setCreatedTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy((Date)createdTime);
        }

        public final Map<String, String> getProvisioningArtifactMetadata() {
            return this.provisioningArtifactMetadata;
        }

        @Override
        public final Builder provisioningArtifactMetadata(Map<String, String> provisioningArtifactMetadata) {
            this.provisioningArtifactMetadata = ProvisioningArtifactInfoCopier.copy(provisioningArtifactMetadata);
            return this;
        }

        public final void setProvisioningArtifactMetadata(Map<String, String> provisioningArtifactMetadata) {
            this.provisioningArtifactMetadata = ProvisioningArtifactInfoCopier.copy(provisioningArtifactMetadata);
        }

        public ProvisioningArtifactSummary build() {
            return new ProvisioningArtifactSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisioningArtifactSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdTime(Date var1);

        public Builder provisioningArtifactMetadata(Map<String, String> var1);
    }
}

