/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.AllowedValuesCopier;
import software.amazon.awssdk.services.servicecatalog.transform.ParameterConstraintsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterConstraints
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterConstraints> {
    private final List<String> allowedValues;

    private ParameterConstraints(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
    }

    public List<String> allowedValues() {
        return this.allowedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allowedValues() == null ? 0 : this.allowedValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConstraints)) {
            return false;
        }
        ParameterConstraints other = (ParameterConstraints)obj;
        if (other.allowedValues() == null ^ this.allowedValues() == null) {
            return false;
        }
        return other.allowedValues() == null || other.allowedValues().equals(this.allowedValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedValues() != null) {
            sb.append("AllowedValues: ").append(this.allowedValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterConstraintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> allowedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConstraints model) {
            this.setAllowedValues(model.allowedValues);
        }

        public final Collection<String> getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            if (this.allowedValues == null) {
                this.allowedValues = new ArrayList<String>(allowedValues.length);
            }
            for (String e : allowedValues) {
                this.allowedValues.add(e);
            }
            return this;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        @SafeVarargs
        public final void setAllowedValues(String ... allowedValues) {
            if (this.allowedValues == null) {
                this.allowedValues = new ArrayList<String>(allowedValues.length);
            }
            for (String e : allowedValues) {
                this.allowedValues.add(e);
            }
        }

        public ParameterConstraints build() {
            return new ParameterConstraints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterConstraints> {
        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);
    }
}

