/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.Principal;
import software.amazon.awssdk.services.servicecatalog.model.PrincipalsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPrincipalsForPortfolioResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPrincipalsForPortfolioResponse> {
    private final List<Principal> principals;
    private final String nextPageToken;

    private ListPrincipalsForPortfolioResponse(BuilderImpl builder) {
        this.principals = builder.principals;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Principal> principals() {
        return this.principals;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.principals() == null ? 0 : this.principals().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalsForPortfolioResponse)) {
            return false;
        }
        ListPrincipalsForPortfolioResponse other = (ListPrincipalsForPortfolioResponse)((Object)obj);
        if (other.principals() == null ^ this.principals() == null) {
            return false;
        }
        if (other.principals() != null && !other.principals().equals(this.principals())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.principals() != null) {
            sb.append("Principals: ").append(this.principals()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Principal> principals;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalsForPortfolioResponse model) {
            this.setPrincipals(model.principals);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<Principal> getPrincipals() {
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal ... principals) {
            if (this.principals == null) {
                this.principals = new ArrayList<Principal>(principals.length);
            }
            for (Principal e : principals) {
                this.principals.add(e);
            }
            return this;
        }

        public final void setPrincipals(Collection<Principal> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        @SafeVarargs
        public final void setPrincipals(Principal ... principals) {
            if (this.principals == null) {
                this.principals = new ArrayList<Principal>(principals.length);
            }
            for (Principal e : principals) {
                this.principals.add(e);
            }
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListPrincipalsForPortfolioResponse build() {
            return new ListPrincipalsForPortfolioResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPrincipalsForPortfolioResponse> {
        public Builder principals(Collection<Principal> var1);

        public Builder principals(Principal ... var1);

        public Builder nextPageToken(String var1);
    }
}

