/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AcceptPortfolioShareRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AcceptPortfolioShareRequest> {
    private final String acceptLanguage;
    private final String portfolioId;

    private AcceptPortfolioShareRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.portfolioId() == null ? 0 : this.portfolioId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptPortfolioShareRequest)) {
            return false;
        }
        AcceptPortfolioShareRequest other = (AcceptPortfolioShareRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.portfolioId() == null ^ this.portfolioId() == null) {
            return false;
        }
        return other.portfolioId() == null || other.portfolioId().equals(this.portfolioId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.portfolioId() != null) {
            sb.append("PortfolioId: ").append(this.portfolioId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptPortfolioShareRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setPortfolioId(model.portfolioId);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public AcceptPortfolioShareRequest build() {
            return new AcceptPortfolioShareRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AcceptPortfolioShareRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);
    }
}

