/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement;

@SdkInternalApi
public class ApplicationPolicyStatementMarshaller {
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<List> PRINCIPALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principals").build();
    private static final MarshallingInfo<String> STATEMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statementId").build();
    private static final ApplicationPolicyStatementMarshaller INSTANCE = new ApplicationPolicyStatementMarshaller();

    public static ApplicationPolicyStatementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationPolicyStatement applicationPolicyStatement, ProtocolMarshaller protocolMarshaller) {
        if (applicationPolicyStatement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(applicationPolicyStatement.actions(), ACTIONS_BINDING);
            protocolMarshaller.marshall(applicationPolicyStatement.principals(), PRINCIPALS_BINDING);
            protocolMarshaller.marshall((Object)applicationPolicyStatement.statementId(), STATEMENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

