/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VersionSummaryMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").isBinary(false).build();
    private static final MarshallingInfo<String> SEMANTICVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("semanticVersion").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCECODEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceCodeUrl").isBinary(false).build();
    private static final VersionSummaryMarshaller INSTANCE = new VersionSummaryMarshaller();

    private VersionSummaryMarshaller() {
    }

    public static VersionSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VersionSummary versionSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)versionSummary, (String)"versionSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)versionSummary.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)versionSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)versionSummary.semanticVersion(), SEMANTICVERSION_BINDING);
            protocolMarshaller.marshall((Object)versionSummary.sourceCodeUrl(), SOURCECODEURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

