/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationPolicyStatement;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOfApplicationPolicyStatementCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutApplicationPolicyResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, PutApplicationPolicyResponse> {
    private final List<ApplicationPolicyStatement> statements;

    private PutApplicationPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.statements = builder.statements;
    }

    public List<ApplicationPolicyStatement> statements() {
        return this.statements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statements());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationPolicyResponse)) {
            return false;
        }
        PutApplicationPolicyResponse other = (PutApplicationPolicyResponse)((Object)obj);
        return Objects.equals(this.statements(), other.statements());
    }

    public String toString() {
        return ToString.builder((String)"PutApplicationPolicyResponse").add("Statements", this.statements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private List<ApplicationPolicyStatement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationPolicyResponse model) {
            super(model);
            this.statements(model.statements);
        }

        public final Collection<ApplicationPolicyStatement.Builder> getStatements() {
            return this.statements != null ? (Collection)this.statements.stream().map(ApplicationPolicyStatement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statements(Collection<ApplicationPolicyStatement> statements) {
            this.statements = ListOfApplicationPolicyStatementCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(ApplicationPolicyStatement ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<ApplicationPolicyStatement.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (ApplicationPolicyStatement)((ApplicationPolicyStatement.Builder)ApplicationPolicyStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatements(Collection<ApplicationPolicyStatement.BuilderImpl> statements) {
            this.statements = ListOfApplicationPolicyStatementCopier.copyFromBuilder(statements);
        }

        @Override
        public PutApplicationPolicyResponse build() {
            return new PutApplicationPolicyResponse(this);
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    CopyableBuilder<Builder, PutApplicationPolicyResponse> {
        public Builder statements(Collection<ApplicationPolicyStatement> var1);

        public Builder statements(ApplicationPolicyStatement ... var1);

        public Builder statements(Consumer<ApplicationPolicyStatement.Builder> ... var1);
    }
}

