/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.VersionSummary;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfVersionSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationVersionsResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, ListApplicationVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListApplicationVersionsResponse.getter(ListApplicationVersionsResponse::nextToken)).setter(ListApplicationVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VersionSummary>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListApplicationVersionsResponse.getter(ListApplicationVersionsResponse::versions)).setter(ListApplicationVersionsResponse.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VERSIONS_FIELD));
    private final String nextToken;
    private final List<VersionSummary> versions;

    private ListApplicationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.versions = builder.versions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VersionSummary> versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationVersionsResponse)) {
            return false;
        }
        ListApplicationVersionsResponse other = (ListApplicationVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.versions(), other.versions());
    }

    public String toString() {
        return ToString.builder((String)"ListApplicationVersionsResponse").add("NextToken", (Object)this.nextToken()).add("Versions", this.versions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationVersionsResponse, T> g) {
        return obj -> g.apply((ListApplicationVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VersionSummary> versions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.versions(model.versions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VersionSummary.Builder> getVersions() {
            return this.versions != null ? (Collection)this.versions.stream().map(VersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<VersionSummary> versions) {
            this.versions = ___listOfVersionSummaryCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(VersionSummary ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<VersionSummary.Builder> ... versions) {
            this.versions(Stream.of(versions).map(c -> (VersionSummary)((VersionSummary.Builder)VersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<VersionSummary.BuilderImpl> versions) {
            this.versions = ___listOfVersionSummaryCopier.copyFromBuilder(versions);
        }

        @Override
        public ListApplicationVersionsResponse build() {
            return new ListApplicationVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder versions(Collection<VersionSummary> var1);

        public Builder versions(VersionSummary ... var1);

        public Builder versions(Consumer<VersionSummary.Builder> ... var1);
    }
}

