/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.serverlessapplicationrepository.ServerlessApplicationRepositoryAsyncClient;
import software.amazon.awssdk.services.serverlessapplicationrepository.internal.UserAgentUtils;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse;

public class ListApplicationDependenciesPublisher
implements SdkPublisher<ListApplicationDependenciesResponse> {
    private final ServerlessApplicationRepositoryAsyncClient client;
    private final ListApplicationDependenciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationDependenciesPublisher(ServerlessApplicationRepositoryAsyncClient client, ListApplicationDependenciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationDependenciesPublisher(ServerlessApplicationRepositoryAsyncClient client, ListApplicationDependenciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationDependenciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationDependenciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListApplicationDependenciesResponseFetcher
    implements AsyncPageFetcher<ListApplicationDependenciesResponse> {
        private ListApplicationDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationDependenciesResponse> nextPage(ListApplicationDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationDependenciesPublisher.this.client.listApplicationDependencies(ListApplicationDependenciesPublisher.this.firstRequest);
            }
            return ListApplicationDependenciesPublisher.this.client.listApplicationDependencies((ListApplicationDependenciesRequest)((Object)ListApplicationDependenciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

