/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationPolicyStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationPolicyStatement> {
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(ApplicationPolicyStatement.getter(ApplicationPolicyStatement::actions)).setter(ApplicationPolicyStatement.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRINCIPAL_ORG_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrincipalOrgIDs").getter(ApplicationPolicyStatement.getter(ApplicationPolicyStatement::principalOrgIDs)).setter(ApplicationPolicyStatement.setter(Builder::principalOrgIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalOrgIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Principals").getter(ApplicationPolicyStatement.getter(ApplicationPolicyStatement::principals)).setter(ApplicationPolicyStatement.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementId").getter(ApplicationPolicyStatement.getter(ApplicationPolicyStatement::statementId)).setter(ApplicationPolicyStatement.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, PRINCIPAL_ORG_I_DS_FIELD, PRINCIPALS_FIELD, STATEMENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> actions;
    private final List<String> principalOrgIDs;
    private final List<String> principals;
    private final String statementId;

    private ApplicationPolicyStatement(BuilderImpl builder) {
        this.actions = builder.actions;
        this.principalOrgIDs = builder.principalOrgIDs;
        this.principals = builder.principals;
        this.statementId = builder.statementId;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final boolean hasPrincipalOrgIDs() {
        return this.principalOrgIDs != null && !(this.principalOrgIDs instanceof SdkAutoConstructList);
    }

    public final List<String> principalOrgIDs() {
        return this.principalOrgIDs;
    }

    public final boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public final List<String> principals() {
        return this.principals;
    }

    public final String statementId() {
        return this.statementId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipalOrgIDs() ? this.principalOrgIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicyStatement)) {
            return false;
        }
        ApplicationPolicyStatement other = (ApplicationPolicyStatement)obj;
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasPrincipalOrgIDs() == other.hasPrincipalOrgIDs() && Objects.equals(this.principalOrgIDs(), other.principalOrgIDs()) && this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.statementId(), other.statementId());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationPolicyStatement").add("Actions", this.hasActions() ? this.actions() : null).add("PrincipalOrgIDs", this.hasPrincipalOrgIDs() ? this.principalOrgIDs() : null).add("Principals", this.hasPrincipals() ? this.principals() : null).add("StatementId", (Object)this.statementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "PrincipalOrgIDs": {
                return Optional.ofNullable(clazz.cast(this.principalOrgIDs()));
            }
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "StatementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationPolicyStatement, T> g) {
        return obj -> g.apply((ApplicationPolicyStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private List<String> principalOrgIDs = DefaultSdkAutoConstructList.getInstance();
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();
        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPolicyStatement model) {
            this.actions(model.actions);
            this.principalOrgIDs(model.principalOrgIDs);
            this.principals(model.principals);
            this.statementId(model.statementId);
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ___listOf__stringCopier.copy(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<String> actions) {
            this.actions = ___listOf__stringCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final Collection<String> getPrincipalOrgIDs() {
            if (this.principalOrgIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principalOrgIDs;
        }

        public final void setPrincipalOrgIDs(Collection<String> principalOrgIDs) {
            this.principalOrgIDs = ___listOf__stringCopier.copy(principalOrgIDs);
        }

        @Override
        @Transient
        public final Builder principalOrgIDs(Collection<String> principalOrgIDs) {
            this.principalOrgIDs = ___listOf__stringCopier.copy(principalOrgIDs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principalOrgIDs(String ... principalOrgIDs) {
            this.principalOrgIDs(Arrays.asList(principalOrgIDs));
            return this;
        }

        public final Collection<String> getPrincipals() {
            if (this.principals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principals;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = ___listOf__stringCopier.copy(principals);
        }

        @Override
        @Transient
        public final Builder principals(Collection<String> principals) {
            this.principals = ___listOf__stringCopier.copy(principals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        @Transient
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public ApplicationPolicyStatement build() {
            return new ApplicationPolicyStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationPolicyStatement> {
        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder principalOrgIDs(Collection<String> var1);

        public Builder principalOrgIDs(String ... var1);

        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder statementId(String var1);
    }
}

