/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationDependencySummary;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOfApplicationDependencySummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationDependenciesResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, ListApplicationDependenciesResponse> {
    private static final SdkField<List<ApplicationDependencySummary>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dependencies").getter(ListApplicationDependenciesResponse.getter(ListApplicationDependenciesResponse::dependencies)).setter(ListApplicationDependenciesResponse.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationDependencySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationDependenciesResponse.getter(ListApplicationDependenciesResponse::nextToken)).setter(ListApplicationDependenciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPENDENCIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationDependencySummary> dependencies;
    private final String nextToken;

    private ListApplicationDependenciesResponse(BuilderImpl builder) {
        super(builder);
        this.dependencies = builder.dependencies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<ApplicationDependencySummary> dependencies() {
        return this.dependencies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationDependenciesResponse)) {
            return false;
        }
        ListApplicationDependenciesResponse other = (ListApplicationDependenciesResponse)((Object)obj);
        return this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationDependenciesResponse").add("Dependencies", this.hasDependencies() ? this.dependencies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationDependenciesResponse, T> g) {
        return obj -> g.apply((ListApplicationDependenciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private List<ApplicationDependencySummary> dependencies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationDependenciesResponse model) {
            super(model);
            this.dependencies(model.dependencies);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationDependencySummary.Builder> getDependencies() {
            List<ApplicationDependencySummary.Builder> result = ___listOfApplicationDependencySummaryCopier.copyToBuilder(this.dependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependencies(Collection<ApplicationDependencySummary.BuilderImpl> dependencies) {
            this.dependencies = ___listOfApplicationDependencySummaryCopier.copyFromBuilder(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<ApplicationDependencySummary> dependencies) {
            this.dependencies = ___listOfApplicationDependencySummaryCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(ApplicationDependencySummary ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<ApplicationDependencySummary.Builder> ... dependencies) {
            this.dependencies(Stream.of(dependencies).map(c -> (ApplicationDependencySummary)((ApplicationDependencySummary.Builder)ApplicationDependencySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationDependenciesResponse build() {
            return new ListApplicationDependenciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationDependenciesResponse> {
        public Builder dependencies(Collection<ApplicationDependencySummary> var1);

        public Builder dependencies(ApplicationDependencySummary ... var1);

        public Builder dependencies(Consumer<ApplicationDependencySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

