/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.serverlessapplicationrepository.ServerlessApplicationRepositoryClient;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse;

public class ListApplicationVersionsIterable
implements SdkIterable<ListApplicationVersionsResponse> {
    private final ServerlessApplicationRepositoryClient client;
    private final ListApplicationVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationVersionsIterable(ServerlessApplicationRepositoryClient client, ListApplicationVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationVersionsResponseFetcher();
    }

    public Iterator<ListApplicationVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListApplicationVersionsResponseFetcher
    implements SyncPageFetcher<ListApplicationVersionsResponse> {
        private ListApplicationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationVersionsResponse nextPage(ListApplicationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationVersionsIterable.this.client.listApplicationVersions(ListApplicationVersionsIterable.this.firstRequest);
            }
            return ListApplicationVersionsIterable.this.client.listApplicationVersions((ListApplicationVersionsRequest)((Object)ListApplicationVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

