/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudFormationChangeSetResponse extends ServerlessApplicationRepositoryResponse implements
        ToCopyableBuilder<CreateCloudFormationChangeSetResponse.Builder, CreateCloudFormationChangeSetResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCloudFormationChangeSetResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCloudFormationChangeSetResponse::changeSetId)).setter(setter(Builder::changeSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeSetId").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCloudFormationChangeSetResponse::semanticVersion)).setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCloudFormationChangeSetResponse::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CHANGE_SET_ID_FIELD, SEMANTIC_VERSION_FIELD, STACK_ID_FIELD));

    private final String applicationId;

    private final String changeSetId;

    private final String semanticVersion;

    private final String stackId;

    private CreateCloudFormationChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.changeSetId = builder.changeSetId;
        this.semanticVersion = builder.semanticVersion;
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * The application Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The application Amazon Resource Name (ARN).
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the change set.
     * </p>
     * <p>
     * Length constraints: Minimum length of 1.
     * </p>
     * <p>
     * Pattern: ARN:[-a-zA-Z0-9:/]*
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the change set.</p>
     *         <p>
     *         Length constraints: Minimum length of 1.
     *         </p>
     *         <p>
     *         Pattern: ARN:[-a-zA-Z0-9:/]*
     */
    public String changeSetId() {
        return changeSetId;
    }

    /**
     * <p>
     * The semantic version of the application:
     * </p>
     * <p>
     * <a href="https://semver.org/">https://semver.org/</a>
     * </p>
     * 
     * @return The semantic version of the application:</p>
     *         <p>
     *         <a href="https://semver.org/">https://semver.org/</a>
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * The unique ID of the stack.
     * </p>
     * 
     * @return The unique ID of the stack.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationChangeSetResponse)) {
            return false;
        }
        CreateCloudFormationChangeSetResponse other = (CreateCloudFormationChangeSetResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(changeSetId(), other.changeSetId())
                && Objects.equals(semanticVersion(), other.semanticVersion()) && Objects.equals(stackId(), other.stackId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCloudFormationChangeSetResponse").add("ApplicationId", applicationId())
                .add("ChangeSetId", changeSetId()).add("SemanticVersion", semanticVersion()).add("StackId", stackId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ChangeSetId":
            return Optional.ofNullable(clazz.cast(changeSetId()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationChangeSetResponse, T> g) {
        return obj -> g.apply((CreateCloudFormationChangeSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudFormationChangeSetResponse> {
        /**
         * <p>
         * The application Amazon Resource Name (ARN).
         * </p>
         * 
         * @param applicationId
         *        The application Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the change set.
         * </p>
         * <p>
         * Length constraints: Minimum length of 1.
         * </p>
         * <p>
         * Pattern: ARN:[-a-zA-Z0-9:/]*
         * </p>
         * 
         * @param changeSetId
         *        The Amazon Resource Name (ARN) of the change set.</p>
         *        <p>
         *        Length constraints: Minimum length of 1.
         *        </p>
         *        <p>
         *        Pattern: ARN:[-a-zA-Z0-9:/]*
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetId(String changeSetId);

        /**
         * <p>
         * The semantic version of the application:
         * </p>
         * <p>
         * <a href="https://semver.org/">https://semver.org/</a>
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the application:</p>
         *        <p>
         *        <a href="https://semver.org/">https://semver.org/</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * The unique ID of the stack.
         * </p>
         * 
         * @param stackId
         *        The unique ID of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryResponse.BuilderImpl implements Builder {
        private String applicationId;

        private String changeSetId;

        private String semanticVersion;

        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationChangeSetResponse model) {
            super(model);
            applicationId(model.applicationId);
            changeSetId(model.changeSetId);
            semanticVersion(model.semanticVersion);
            stackId(model.stackId);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getChangeSetId() {
            return changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public CreateCloudFormationChangeSetResponse build() {
            return new CreateCloudFormationChangeSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
