/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends ServerlessApplicationRepositoryRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> AUTHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::author)).setter(setter(Builder::author))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> HOME_PAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::homePageUrl)).setter(setter(Builder::homePageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePageUrl").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateApplicationRequest::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LICENSE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::licenseBody)).setter(setter(Builder::licenseBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseBody").build()).build();

    private static final SdkField<String> LICENSE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::licenseUrl)).setter(setter(Builder::licenseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseUrl").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> README_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::readmeBody)).setter(setter(Builder::readmeBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeBody").build()).build();

    private static final SdkField<String> README_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::readmeUrl)).setter(setter(Builder::readmeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUrl").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::semanticVersion)).setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()).build();

    private static final SdkField<String> SOURCE_CODE_ARCHIVE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::sourceCodeArchiveUrl)).setter(setter(Builder::sourceCodeArchiveUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeArchiveUrl").build())
            .build();

    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::sourceCodeUrl)).setter(setter(Builder::sourceCodeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()).build();

    private static final SdkField<String> SPDX_LICENSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::spdxLicenseId)).setter(setter(Builder::spdxLicenseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spdxLicenseId").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateApplicationRequest::templateUrl)).setter(setter(Builder::templateUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHOR_FIELD,
            DESCRIPTION_FIELD, HOME_PAGE_URL_FIELD, LABELS_FIELD, LICENSE_BODY_FIELD, LICENSE_URL_FIELD, NAME_FIELD,
            README_BODY_FIELD, README_URL_FIELD, SEMANTIC_VERSION_FIELD, SOURCE_CODE_ARCHIVE_URL_FIELD, SOURCE_CODE_URL_FIELD,
            SPDX_LICENSE_ID_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD));

    private final String author;

    private final String description;

    private final String homePageUrl;

    private final List<String> labels;

    private final String licenseBody;

    private final String licenseUrl;

    private final String name;

    private final String readmeBody;

    private final String readmeUrl;

    private final String semanticVersion;

    private final String sourceCodeArchiveUrl;

    private final String sourceCodeUrl;

    private final String spdxLicenseId;

    private final String templateBody;

    private final String templateUrl;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.author = builder.author;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.labels = builder.labels;
        this.licenseBody = builder.licenseBody;
        this.licenseUrl = builder.licenseUrl;
        this.name = builder.name;
        this.readmeBody = builder.readmeBody;
        this.readmeUrl = builder.readmeUrl;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeArchiveUrl = builder.sourceCodeArchiveUrl;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.spdxLicenseId = builder.spdxLicenseId;
        this.templateBody = builder.templateBody;
        this.templateUrl = builder.templateUrl;
    }

    /**
     * <p>
     * The name of the author publishing the app.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=127.
     * </p>
     * <p>
     * Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     * </p>
     * 
     * @return The name of the author publishing the app.</p>
     *         <p>
     *         Minimum length=1. Maximum length=127.
     *         </p>
     *         <p>
     *         Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
     */
    public String author() {
        return author;
    }

    /**
     * <p>
     * The description of the application.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=256
     * </p>
     * 
     * @return The description of the application.</p>
     *         <p>
     *         Minimum length=1. Maximum length=256
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A URL with more information about the application, for example the location of your GitHub repository for the
     * application.
     * </p>
     * 
     * @return A URL with more information about the application, for example the location of your GitHub repository for
     *         the application.
     */
    public String homePageUrl() {
        return homePageUrl;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Labels to improve discovery of apps in search results.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=127. Maximum number of labels: 10
     * </p>
     * <p>
     * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Labels to improve discovery of apps in search results.</p>
     *         <p>
     *         Minimum length=1. Maximum length=127. Maximum number of labels: 10
     *         </p>
     *         <p>
     *         Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
     */
    public List<String> labels() {
        return labels;
    }

    /**
     * <p>
     * A local text file that contains the license of the app that matches the spdxLicenseID value of your application.
     * The file has the format file://&lt;path>/&lt;filename>.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * <p>
     * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
     * </p>
     * 
     * @return A local text file that contains the license of the app that matches the spdxLicenseID value of your
     *         application. The file has the format file://&lt;path>/&lt;filename>.</p>
     *         <p>
     *         Maximum size 5 MB
     *         </p>
     *         <p>
     *         You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
     */
    public String licenseBody() {
        return licenseBody;
    }

    /**
     * <p>
     * A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your
     * application.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * <p>
     * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
     * </p>
     * 
     * @return A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your
     *         application.</p>
     *         <p>
     *         Maximum size 5 MB
     *         </p>
     *         <p>
     *         You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
     */
    public String licenseUrl() {
        return licenseUrl;
    }

    /**
     * <p>
     * The name of the application that you want to publish.
     * </p>
     * <p>
     * Minimum length=1. Maximum length=140
     * </p>
     * <p>
     * Pattern: "[a-zA-Z0-9\\-]+";
     * </p>
     * 
     * @return The name of the application that you want to publish.</p>
     *         <p>
     *         Minimum length=1. Maximum length=140
     *         </p>
     *         <p>
     *         Pattern: "[a-zA-Z0-9\\-]+";
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A local text readme file in Markdown language that contains a more detailed description of the application and
     * how it works. The file has the format file://&lt;path>/&lt;filename>.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * <p>
     * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
     * </p>
     * 
     * @return A local text readme file in Markdown language that contains a more detailed description of the
     *         application and how it works. The file has the format file://&lt;path>/&lt;filename>.</p>
     *         <p>
     *         Maximum size 5 MB
     *         </p>
     *         <p>
     *         You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
     */
    public String readmeBody() {
        return readmeBody;
    }

    /**
     * <p>
     * A link to the S3 object in Markdown language that contains a more detailed description of the application and how
     * it works.
     * </p>
     * <p>
     * Maximum size 5 MB
     * </p>
     * <p>
     * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
     * </p>
     * 
     * @return A link to the S3 object in Markdown language that contains a more detailed description of the application
     *         and how it works.</p>
     *         <p>
     *         Maximum size 5 MB
     *         </p>
     *         <p>
     *         You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
     */
    public String readmeUrl() {
        return readmeUrl;
    }

    /**
     * <p>
     * The semantic version of the application:
     * </p>
     * <p>
     * <a href="https://semver.org/">https://semver.org/</a>
     * </p>
     * 
     * @return The semantic version of the application:</p>
     *         <p>
     *         <a href="https://semver.org/">https://semver.org/</a>
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * A link to the S3 object that contains the ZIP archive of the source code for this version of your application.
     * </p>
     * <p>
     * Maximum size 50 MB
     * </p>
     * 
     * @return A link to the S3 object that contains the ZIP archive of the source code for this version of your
     *         application.</p>
     *         <p>
     *         Maximum size 50 MB
     */
    public String sourceCodeArchiveUrl() {
        return sourceCodeArchiveUrl;
    }

    /**
     * <p>
     * A link to a public repository for the source code of your application, for example the URL of a specific GitHub
     * commit.
     * </p>
     * 
     * @return A link to a public repository for the source code of your application, for example the URL of a specific
     *         GitHub commit.
     */
    public String sourceCodeUrl() {
        return sourceCodeUrl;
    }

    /**
     * <p>
     * A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.
     * </p>
     * 
     * @return A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.
     */
    public String spdxLicenseId() {
        return spdxLicenseId;
    }

    /**
     * <p>
     * The local raw packaged AWS SAM template file of your application. The file has the format
     * file://&lt;path>/&lt;filename>.
     * </p>
     * <p>
     * You can specify only one of templateBody and templateUrl; otherwise an error results.
     * </p>
     * 
     * @return The local raw packaged AWS SAM template file of your application. The file has the format
     *         file://&lt;path>/&lt;filename>.</p>
     *         <p>
     *         You can specify only one of templateBody and templateUrl; otherwise an error results.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * A link to the S3 object containing the packaged AWS SAM template of your application.
     * </p>
     * <p>
     * You can specify only one of templateBody and templateUrl; otherwise an error results.
     * </p>
     * 
     * @return A link to the S3 object containing the packaged AWS SAM template of your application.</p>
     *         <p>
     *         You can specify only one of templateBody and templateUrl; otherwise an error results.
     */
    public String templateUrl() {
        return templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        hashCode = 31 * hashCode + Objects.hashCode(licenseBody());
        hashCode = 31 * hashCode + Objects.hashCode(licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(readmeBody());
        hashCode = 31 * hashCode + Objects.hashCode(readmeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeArchiveUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(spdxLicenseId());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(author(), other.author()) && Objects.equals(description(), other.description())
                && Objects.equals(homePageUrl(), other.homePageUrl()) && Objects.equals(labels(), other.labels())
                && Objects.equals(licenseBody(), other.licenseBody()) && Objects.equals(licenseUrl(), other.licenseUrl())
                && Objects.equals(name(), other.name()) && Objects.equals(readmeBody(), other.readmeBody())
                && Objects.equals(readmeUrl(), other.readmeUrl()) && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(sourceCodeArchiveUrl(), other.sourceCodeArchiveUrl())
                && Objects.equals(sourceCodeUrl(), other.sourceCodeUrl())
                && Objects.equals(spdxLicenseId(), other.spdxLicenseId()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateUrl(), other.templateUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateApplicationRequest").add("Author", author()).add("Description", description())
                .add("HomePageUrl", homePageUrl()).add("Labels", labels()).add("LicenseBody", licenseBody())
                .add("LicenseUrl", licenseUrl()).add("Name", name()).add("ReadmeBody", readmeBody())
                .add("ReadmeUrl", readmeUrl()).add("SemanticVersion", semanticVersion())
                .add("SourceCodeArchiveUrl", sourceCodeArchiveUrl()).add("SourceCodeUrl", sourceCodeUrl())
                .add("SpdxLicenseId", spdxLicenseId()).add("TemplateBody", templateBody()).add("TemplateUrl", templateUrl())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Author":
            return Optional.ofNullable(clazz.cast(author()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HomePageUrl":
            return Optional.ofNullable(clazz.cast(homePageUrl()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "LicenseBody":
            return Optional.ofNullable(clazz.cast(licenseBody()));
        case "LicenseUrl":
            return Optional.ofNullable(clazz.cast(licenseUrl()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ReadmeBody":
            return Optional.ofNullable(clazz.cast(readmeBody()));
        case "ReadmeUrl":
            return Optional.ofNullable(clazz.cast(readmeUrl()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "SourceCodeArchiveUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeArchiveUrl()));
        case "SourceCodeUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeUrl()));
        case "SpdxLicenseId":
            return Optional.ofNullable(clazz.cast(spdxLicenseId()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateUrl":
            return Optional.ofNullable(clazz.cast(templateUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of the author publishing the app.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127.
         * </p>
         * <p>
         * Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * </p>
         * 
         * @param author
         *        The name of the author publishing the app.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127.
         *        </p>
         *        <p>
         *        Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * <p>
         * The description of the application.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=256
         * </p>
         * 
         * @param description
         *        The description of the application.</p>
         *        <p>
         *        Minimum length=1. Maximum length=256
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A URL with more information about the application, for example the location of your GitHub repository for the
         * application.
         * </p>
         * 
         * @param homePageUrl
         *        A URL with more information about the application, for example the location of your GitHub repository
         *        for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePageUrl(String homePageUrl);

        /**
         * <p>
         * Labels to improve discovery of apps in search results.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         * </p>
         * <p>
         * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * </p>
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *        </p>
         *        <p>
         *        Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * Labels to improve discovery of apps in search results.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         * </p>
         * <p>
         * Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * </p>
         * 
         * @param labels
         *        Labels to improve discovery of apps in search results.</p>
         *        <p>
         *        Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *        </p>
         *        <p>
         *        Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * A local text file that contains the license of the app that matches the spdxLicenseID value of your
         * application. The file has the format file://&lt;path>/&lt;filename>.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * <p>
         * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
         * </p>
         * 
         * @param licenseBody
         *        A local text file that contains the license of the app that matches the spdxLicenseID value of your
         *        application. The file has the format file://&lt;path>/&lt;filename>.</p>
         *        <p>
         *        Maximum size 5 MB
         *        </p>
         *        <p>
         *        You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseBody(String licenseBody);

        /**
         * <p>
         * A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your
         * application.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * <p>
         * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
         * </p>
         * 
         * @param licenseUrl
         *        A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of
         *        your application.</p>
         *        <p>
         *        Maximum size 5 MB
         *        </p>
         *        <p>
         *        You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseUrl(String licenseUrl);

        /**
         * <p>
         * The name of the application that you want to publish.
         * </p>
         * <p>
         * Minimum length=1. Maximum length=140
         * </p>
         * <p>
         * Pattern: "[a-zA-Z0-9\\-]+";
         * </p>
         * 
         * @param name
         *        The name of the application that you want to publish.</p>
         *        <p>
         *        Minimum length=1. Maximum length=140
         *        </p>
         *        <p>
         *        Pattern: "[a-zA-Z0-9\\-]+";
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A local text readme file in Markdown language that contains a more detailed description of the application
         * and how it works. The file has the format file://&lt;path>/&lt;filename>.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * <p>
         * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
         * </p>
         * 
         * @param readmeBody
         *        A local text readme file in Markdown language that contains a more detailed description of the
         *        application and how it works. The file has the format file://&lt;path>/&lt;filename>.</p>
         *        <p>
         *        Maximum size 5 MB
         *        </p>
         *        <p>
         *        You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeBody(String readmeBody);

        /**
         * <p>
         * A link to the S3 object in Markdown language that contains a more detailed description of the application and
         * how it works.
         * </p>
         * <p>
         * Maximum size 5 MB
         * </p>
         * <p>
         * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
         * </p>
         * 
         * @param readmeUrl
         *        A link to the S3 object in Markdown language that contains a more detailed description of the
         *        application and how it works.</p>
         *        <p>
         *        Maximum size 5 MB
         *        </p>
         *        <p>
         *        You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeUrl(String readmeUrl);

        /**
         * <p>
         * The semantic version of the application:
         * </p>
         * <p>
         * <a href="https://semver.org/">https://semver.org/</a>
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the application:</p>
         *        <p>
         *        <a href="https://semver.org/">https://semver.org/</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * A link to the S3 object that contains the ZIP archive of the source code for this version of your
         * application.
         * </p>
         * <p>
         * Maximum size 50 MB
         * </p>
         * 
         * @param sourceCodeArchiveUrl
         *        A link to the S3 object that contains the ZIP archive of the source code for this version of your
         *        application.</p>
         *        <p>
         *        Maximum size 50 MB
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl);

        /**
         * <p>
         * A link to a public repository for the source code of your application, for example the URL of a specific
         * GitHub commit.
         * </p>
         * 
         * @param sourceCodeUrl
         *        A link to a public repository for the source code of your application, for example the URL of a
         *        specific GitHub commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeUrl(String sourceCodeUrl);

        /**
         * <p>
         * A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.
         * </p>
         * 
         * @param spdxLicenseId
         *        A valid identifier from <a href="https://spdx.org/licenses/">https://spdx.org/licenses/</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spdxLicenseId(String spdxLicenseId);

        /**
         * <p>
         * The local raw packaged AWS SAM template file of your application. The file has the format
         * file://&lt;path>/&lt;filename>.
         * </p>
         * <p>
         * You can specify only one of templateBody and templateUrl; otherwise an error results.
         * </p>
         * 
         * @param templateBody
         *        The local raw packaged AWS SAM template file of your application. The file has the format
         *        file://&lt;path>/&lt;filename>.</p>
         *        <p>
         *        You can specify only one of templateBody and templateUrl; otherwise an error results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * A link to the S3 object containing the packaged AWS SAM template of your application.
         * </p>
         * <p>
         * You can specify only one of templateBody and templateUrl; otherwise an error results.
         * </p>
         * 
         * @param templateUrl
         *        A link to the S3 object containing the packaged AWS SAM template of your application.</p>
         *        <p>
         *        You can specify only one of templateBody and templateUrl; otherwise an error results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateUrl(String templateUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryRequest.BuilderImpl implements Builder {
        private String author;

        private String description;

        private String homePageUrl;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private String licenseBody;

        private String licenseUrl;

        private String name;

        private String readmeBody;

        private String readmeUrl;

        private String semanticVersion;

        private String sourceCodeArchiveUrl;

        private String sourceCodeUrl;

        private String spdxLicenseId;

        private String templateBody;

        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            author(model.author);
            description(model.description);
            homePageUrl(model.homePageUrl);
            labels(model.labels);
            licenseBody(model.licenseBody);
            licenseUrl(model.licenseUrl);
            name(model.name);
            readmeBody(model.readmeBody);
            readmeUrl(model.readmeUrl);
            semanticVersion(model.semanticVersion);
            sourceCodeArchiveUrl(model.sourceCodeArchiveUrl);
            sourceCodeUrl(model.sourceCodeUrl);
            spdxLicenseId(model.spdxLicenseId);
            templateBody(model.templateBody);
            templateUrl(model.templateUrl);
        }

        public final String getAuthor() {
            return author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHomePageUrl() {
            return homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        public final Collection<String> getLabels() {
            return labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        public final String getLicenseBody() {
            return licenseBody;
        }

        @Override
        public final Builder licenseBody(String licenseBody) {
            this.licenseBody = licenseBody;
            return this;
        }

        public final void setLicenseBody(String licenseBody) {
            this.licenseBody = licenseBody;
        }

        public final String getLicenseUrl() {
            return licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getReadmeBody() {
            return readmeBody;
        }

        @Override
        public final Builder readmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
            return this;
        }

        public final void setReadmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
        }

        public final String getReadmeUrl() {
            return readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeArchiveUrl() {
            return sourceCodeArchiveUrl;
        }

        @Override
        public final Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
            return this;
        }

        public final void setSourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
        }

        public final String getSourceCodeUrl() {
            return sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public final String getSpdxLicenseId() {
            return spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateUrl() {
            return templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
