/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource;
import software.amazon.awssdk.services.securitylake.model.CustomLogSourceResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogSourceResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogSourceResource> {
    private static final SdkField<AwsLogSourceResource> AWS_LOG_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsLogSource").getter(LogSourceResource.getter(LogSourceResource::awsLogSource)).setter(LogSourceResource.setter(Builder::awsLogSource)).constructor(AwsLogSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogSource").build()}).build();
    private static final SdkField<CustomLogSourceResource> CUSTOM_LOG_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customLogSource").getter(LogSourceResource.getter(LogSourceResource::customLogSource)).setter(LogSourceResource.setter(Builder::customLogSource)).constructor(CustomLogSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLogSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LOG_SOURCE_FIELD, CUSTOM_LOG_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("awsLogSource", AWS_LOG_SOURCE_FIELD);
            this.put("customLogSource", CUSTOM_LOG_SOURCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AwsLogSourceResource awsLogSource;
    private final CustomLogSourceResource customLogSource;
    private final Type type;

    private LogSourceResource(BuilderImpl builder) {
        this.awsLogSource = builder.awsLogSource;
        this.customLogSource = builder.customLogSource;
        this.type = builder.type;
    }

    public final AwsLogSourceResource awsLogSource() {
        return this.awsLogSource;
    }

    public final CustomLogSourceResource customLogSource() {
        return this.customLogSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLogSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLogSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSourceResource)) {
            return false;
        }
        LogSourceResource other = (LogSourceResource)obj;
        return Objects.equals(this.awsLogSource(), other.awsLogSource()) && Objects.equals(this.customLogSource(), other.customLogSource());
    }

    public final String toString() {
        return ToString.builder((String)"LogSourceResource").add("AwsLogSource", (Object)this.awsLogSource()).add("CustomLogSource", (Object)this.customLogSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsLogSource": {
                return Optional.ofNullable(clazz.cast(this.awsLogSource()));
            }
            case "customLogSource": {
                return Optional.ofNullable(clazz.cast(this.customLogSource()));
            }
        }
        return Optional.empty();
    }

    public static LogSourceResource fromAwsLogSource(AwsLogSourceResource awsLogSource) {
        return (LogSourceResource)LogSourceResource.builder().awsLogSource(awsLogSource).build();
    }

    public static LogSourceResource fromAwsLogSource(Consumer<AwsLogSourceResource.Builder> awsLogSource) {
        AwsLogSourceResource.Builder builder = AwsLogSourceResource.builder();
        awsLogSource.accept(builder);
        return LogSourceResource.fromAwsLogSource((AwsLogSourceResource)builder.build());
    }

    public static LogSourceResource fromCustomLogSource(CustomLogSourceResource customLogSource) {
        return (LogSourceResource)LogSourceResource.builder().customLogSource(customLogSource).build();
    }

    public static LogSourceResource fromCustomLogSource(Consumer<CustomLogSourceResource.Builder> customLogSource) {
        CustomLogSourceResource.Builder builder = CustomLogSourceResource.builder();
        customLogSource.accept(builder);
        return LogSourceResource.fromCustomLogSource((CustomLogSourceResource)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LogSourceResource, T> g) {
        return obj -> g.apply((LogSourceResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AWS_LOG_SOURCE,
        CUSTOM_LOG_SOURCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AwsLogSourceResource awsLogSource;
        private CustomLogSourceResource customLogSource;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(LogSourceResource model) {
            this.awsLogSource(model.awsLogSource);
            this.customLogSource(model.customLogSource);
        }

        public final AwsLogSourceResource.Builder getAwsLogSource() {
            return this.awsLogSource != null ? this.awsLogSource.toBuilder() : null;
        }

        public final void setAwsLogSource(AwsLogSourceResource.BuilderImpl awsLogSource) {
            AwsLogSourceResource oldValue = this.awsLogSource;
            this.awsLogSource = awsLogSource != null ? awsLogSource.build() : null;
            this.handleUnionValueChange(Type.AWS_LOG_SOURCE, oldValue, this.awsLogSource);
        }

        @Override
        public final Builder awsLogSource(AwsLogSourceResource awsLogSource) {
            AwsLogSourceResource oldValue = this.awsLogSource;
            this.awsLogSource = awsLogSource;
            this.handleUnionValueChange(Type.AWS_LOG_SOURCE, oldValue, this.awsLogSource);
            return this;
        }

        public final CustomLogSourceResource.Builder getCustomLogSource() {
            return this.customLogSource != null ? this.customLogSource.toBuilder() : null;
        }

        public final void setCustomLogSource(CustomLogSourceResource.BuilderImpl customLogSource) {
            CustomLogSourceResource oldValue = this.customLogSource;
            this.customLogSource = customLogSource != null ? customLogSource.build() : null;
            this.handleUnionValueChange(Type.CUSTOM_LOG_SOURCE, oldValue, this.customLogSource);
        }

        @Override
        public final Builder customLogSource(CustomLogSourceResource customLogSource) {
            CustomLogSourceResource oldValue = this.customLogSource;
            this.customLogSource = customLogSource;
            this.handleUnionValueChange(Type.CUSTOM_LOG_SOURCE, oldValue, this.customLogSource);
            return this;
        }

        public LogSourceResource build() {
            return new LogSourceResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogSourceResource> {
        public Builder awsLogSource(AwsLogSourceResource var1);

        default public Builder awsLogSource(Consumer<AwsLogSourceResource.Builder> awsLogSource) {
            return this.awsLogSource((AwsLogSourceResource)((AwsLogSourceResource.Builder)AwsLogSourceResource.builder().applyMutation(awsLogSource)).build());
        }

        public Builder customLogSource(CustomLogSourceResource var1);

        default public Builder customLogSource(Consumer<CustomLogSourceResource.Builder> customLogSource) {
            return this.customLogSource((CustomLogSourceResource)((CustomLogSourceResource.Builder)CustomLogSourceResource.builder().applyMutation(customLogSource)).build());
        }
    }
}

