/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleExpiration;
import software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransition;
import software.amazon.awssdk.services.securitylake.model.DataLakeLifecycleTransitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeLifecycleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeLifecycleConfiguration> {
    private static final SdkField<DataLakeLifecycleExpiration> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("expiration").getter(DataLakeLifecycleConfiguration.getter(DataLakeLifecycleConfiguration::expiration)).setter(DataLakeLifecycleConfiguration.setter(Builder::expiration)).constructor(DataLakeLifecycleExpiration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()}).build();
    private static final SdkField<List<DataLakeLifecycleTransition>> TRANSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transitions").getter(DataLakeLifecycleConfiguration.getter(DataLakeLifecycleConfiguration::transitions)).setter(DataLakeLifecycleConfiguration.setter(Builder::transitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeLifecycleTransition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_FIELD, TRANSITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("expiration", EXPIRATION_FIELD);
            this.put("transitions", TRANSITIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DataLakeLifecycleExpiration expiration;
    private final List<DataLakeLifecycleTransition> transitions;

    private DataLakeLifecycleConfiguration(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.transitions = builder.transitions;
    }

    public final DataLakeLifecycleExpiration expiration() {
        return this.expiration;
    }

    public final boolean hasTransitions() {
        return this.transitions != null && !(this.transitions instanceof SdkAutoConstructList);
    }

    public final List<DataLakeLifecycleTransition> transitions() {
        return this.transitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitions() ? this.transitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeLifecycleConfiguration)) {
            return false;
        }
        DataLakeLifecycleConfiguration other = (DataLakeLifecycleConfiguration)obj;
        return Objects.equals(this.expiration(), other.expiration()) && this.hasTransitions() == other.hasTransitions() && Objects.equals(this.transitions(), other.transitions());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeLifecycleConfiguration").add("Expiration", (Object)this.expiration()).add("Transitions", this.hasTransitions() ? this.transitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "transitions": {
                return Optional.ofNullable(clazz.cast(this.transitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeLifecycleConfiguration, T> g) {
        return obj -> g.apply((DataLakeLifecycleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataLakeLifecycleExpiration expiration;
        private List<DataLakeLifecycleTransition> transitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeLifecycleConfiguration model) {
            this.expiration(model.expiration);
            this.transitions(model.transitions);
        }

        public final DataLakeLifecycleExpiration.Builder getExpiration() {
            return this.expiration != null ? this.expiration.toBuilder() : null;
        }

        public final void setExpiration(DataLakeLifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        @Override
        public final Builder expiration(DataLakeLifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final List<DataLakeLifecycleTransition.Builder> getTransitions() {
            List<DataLakeLifecycleTransition.Builder> result = DataLakeLifecycleTransitionListCopier.copyToBuilder(this.transitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitions(Collection<DataLakeLifecycleTransition.BuilderImpl> transitions) {
            this.transitions = DataLakeLifecycleTransitionListCopier.copyFromBuilder(transitions);
        }

        @Override
        public final Builder transitions(Collection<DataLakeLifecycleTransition> transitions) {
            this.transitions = DataLakeLifecycleTransitionListCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(DataLakeLifecycleTransition ... transitions) {
            this.transitions(Arrays.asList(transitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Consumer<DataLakeLifecycleTransition.Builder> ... transitions) {
            this.transitions(Stream.of(transitions).map(c -> (DataLakeLifecycleTransition)((DataLakeLifecycleTransition.Builder)DataLakeLifecycleTransition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataLakeLifecycleConfiguration build() {
            return new DataLakeLifecycleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeLifecycleConfiguration> {
        public Builder expiration(DataLakeLifecycleExpiration var1);

        default public Builder expiration(Consumer<DataLakeLifecycleExpiration.Builder> expiration) {
            return this.expiration((DataLakeLifecycleExpiration)((DataLakeLifecycleExpiration.Builder)DataLakeLifecycleExpiration.builder().applyMutation(expiration)).build());
        }

        public Builder transitions(Collection<DataLakeLifecycleTransition> var1);

        public Builder transitions(DataLakeLifecycleTransition ... var1);

        public Builder transitions(Consumer<DataLakeLifecycleTransition.Builder> ... var1);
    }
}

