/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse;
import software.amazon.awssdk.services.securitylake.model.LogSource;

public class ListLogSourcesIterable
implements SdkIterable<ListLogSourcesResponse> {
    private final SecurityLakeClient client;
    private final ListLogSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLogSourcesIterable(SecurityLakeClient client, ListLogSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLogSourcesResponseFetcher();
    }

    public Iterator<ListLogSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LogSource> sources() {
        Function<ListLogSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sources() != null) {
                return response.sources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLogSourcesResponseFetcher
    implements SyncPageFetcher<ListLogSourcesResponse> {
        private ListLogSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListLogSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLogSourcesResponse nextPage(ListLogSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListLogSourcesIterable.this.client.listLogSources(ListLogSourcesIterable.this.firstRequest);
            }
            return ListLogSourcesIterable.this.client.listLogSources((ListLogSourcesRequest)((Object)ListLogSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

