/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.securitylake.DefaultSecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.DefaultSecurityLakeBaseClientBuilder;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClientBuilder;
import software.amazon.awssdk.services.securitylake.SecurityLakeServiceClientConfiguration;
import software.amazon.awssdk.services.securitylake.endpoints.SecurityLakeEndpointProvider;

@SdkInternalApi
final class DefaultSecurityLakeAsyncClientBuilder
extends DefaultSecurityLakeBaseClientBuilder<SecurityLakeAsyncClientBuilder, SecurityLakeAsyncClient>
implements SecurityLakeAsyncClientBuilder {
    DefaultSecurityLakeAsyncClientBuilder() {
    }

    @Override
    public DefaultSecurityLakeAsyncClientBuilder endpointProvider(SecurityLakeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SecurityLakeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSecurityLakeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SecurityLakeServiceClientConfiguration serviceClientConfiguration = SecurityLakeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSecurityLakeAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

