/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.SecurityLakeServiceClientConfiguration;
import software.amazon.awssdk.services.securitylake.model.AccessDeniedException;
import software.amazon.awssdk.services.securitylake.model.BadRequestException;
import software.amazon.awssdk.services.securitylake.model.ConflictException;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.CreateCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDataLakeExceptionSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDataLakeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDataLakeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.CreateDataLakeRequest;
import software.amazon.awssdk.services.securitylake.model.CreateDataLakeResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberNotificationRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberNotificationResponse;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteAwsLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteCustomLogSourceResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDataLakeExceptionSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDataLakeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteDataLakeRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteDataLakeResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberNotificationRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberNotificationResponse;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.DeregisterDataLakeDelegatedAdministratorRequest;
import software.amazon.awssdk.services.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeExceptionSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.GetDataLakeSourcesResponse;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.GetSubscriberResponse;
import software.amazon.awssdk.services.securitylake.model.InternalServerException;
import software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse;
import software.amazon.awssdk.services.securitylake.model.ListDataLakesRequest;
import software.amazon.awssdk.services.securitylake.model.ListDataLakesResponse;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersRequest;
import software.amazon.awssdk.services.securitylake.model.ListSubscribersResponse;
import software.amazon.awssdk.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest;
import software.amazon.awssdk.services.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse;
import software.amazon.awssdk.services.securitylake.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeException;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.services.securitylake.model.ThrottlingException;
import software.amazon.awssdk.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateDataLakeRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateDataLakeResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberNotificationResponse;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.securitylake.model.UpdateSubscriberResponse;
import software.amazon.awssdk.services.securitylake.paginators.GetDataLakeSourcesIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListDataLakeExceptionsIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListLogSourcesIterable;
import software.amazon.awssdk.services.securitylake.paginators.ListSubscribersIterable;
import software.amazon.awssdk.services.securitylake.transform.CreateAwsLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateCustomLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateDataLakeExceptionSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateDataLakeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateDataLakeRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateSubscriberNotificationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.CreateSubscriberRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteAwsLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteCustomLogSourceRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteDataLakeExceptionSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteDataLakeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteDataLakeRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteSubscriberNotificationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeleteSubscriberRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.DeregisterDataLakeDelegatedAdministratorRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDataLakeExceptionSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDataLakeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetDataLakeSourcesRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.GetSubscriberRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.ListDataLakeExceptionsRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.ListDataLakesRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.ListLogSourcesRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.ListSubscribersRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.RegisterDataLakeDelegatedAdministratorRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateDataLakeExceptionSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateDataLakeRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateSubscriberNotificationRequestMarshaller;
import software.amazon.awssdk.services.securitylake.transform.UpdateSubscriberRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSecurityLakeClient
implements SecurityLakeClient {
    private static final Logger log = Logger.loggerFor(DefaultSecurityLakeClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final SecurityLakeServiceClientConfiguration serviceClientConfiguration;

    protected DefaultSecurityLakeClient(SecurityLakeServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAwsLogSourceResponse createAwsLogSource(CreateAwsLogSourceRequest createAwsLogSourceRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAwsLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createAwsLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAwsLogSource");
            CreateAwsLogSourceResponse createAwsLogSourceResponse = (CreateAwsLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAwsLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAwsLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAwsLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAwsLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createAwsLogSource$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomLogSourceResponse createCustomLogSource(CreateCustomLogSourceRequest createCustomLogSourceRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createCustomLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomLogSource");
            CreateCustomLogSourceResponse createCustomLogSourceResponse = (CreateCustomLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createCustomLogSource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataLakeResponse createDataLake(CreateDataLakeRequest createDataLakeRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataLakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createDataLakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataLake");
            CreateDataLakeResponse createDataLakeResponse = (CreateDataLakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataLake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataLakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataLakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataLakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createDataLake$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataLakeExceptionSubscriptionResponse createDataLakeExceptionSubscription(CreateDataLakeExceptionSubscriptionRequest createDataLakeExceptionSubscriptionRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataLakeExceptionSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createDataLakeExceptionSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataLakeExceptionSubscription");
            CreateDataLakeExceptionSubscriptionResponse createDataLakeExceptionSubscriptionResponse = (CreateDataLakeExceptionSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataLakeExceptionSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataLakeExceptionSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataLakeExceptionSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataLakeExceptionSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createDataLakeExceptionSubscription$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataLakeOrganizationConfigurationResponse createDataLakeOrganizationConfiguration(CreateDataLakeOrganizationConfigurationRequest createDataLakeOrganizationConfigurationRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataLakeOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createDataLakeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataLakeOrganizationConfiguration");
            CreateDataLakeOrganizationConfigurationResponse createDataLakeOrganizationConfigurationResponse = (CreateDataLakeOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataLakeOrganizationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataLakeOrganizationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataLakeOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataLakeOrganizationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createDataLakeOrganizationConfiguration$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubscriberResponse createSubscriber(CreateSubscriberRequest createSubscriberRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubscriber");
            CreateSubscriberResponse createSubscriberResponse = (CreateSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createSubscriber$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubscriberNotificationResponse createSubscriberNotification(CreateSubscriberNotificationRequest createSubscriberNotificationRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSubscriberNotificationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, createSubscriberNotificationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSubscriberNotification");
            CreateSubscriberNotificationResponse createSubscriberNotificationResponse = (CreateSubscriberNotificationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSubscriberNotification").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSubscriberNotificationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSubscriberNotificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSubscriberNotificationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$createSubscriberNotification$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAwsLogSourceResponse deleteAwsLogSource(DeleteAwsLogSourceRequest deleteAwsLogSourceRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAwsLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteAwsLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAwsLogSource");
            DeleteAwsLogSourceResponse deleteAwsLogSourceResponse = (DeleteAwsLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAwsLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAwsLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAwsLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAwsLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteAwsLogSource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomLogSourceResponse deleteCustomLogSource(DeleteCustomLogSourceRequest deleteCustomLogSourceRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomLogSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomLogSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomLogSource");
            DeleteCustomLogSourceResponse deleteCustomLogSourceResponse = (DeleteCustomLogSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomLogSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomLogSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomLogSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomLogSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteCustomLogSource$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataLakeResponse deleteDataLake(DeleteDataLakeRequest deleteDataLakeRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataLakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteDataLakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataLake");
            DeleteDataLakeResponse deleteDataLakeResponse = (DeleteDataLakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataLake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataLakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataLakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataLakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteDataLake$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataLakeExceptionSubscriptionResponse deleteDataLakeExceptionSubscription(DeleteDataLakeExceptionSubscriptionRequest deleteDataLakeExceptionSubscriptionRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataLakeExceptionSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteDataLakeExceptionSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataLakeExceptionSubscription");
            DeleteDataLakeExceptionSubscriptionResponse deleteDataLakeExceptionSubscriptionResponse = (DeleteDataLakeExceptionSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataLakeExceptionSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataLakeExceptionSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataLakeExceptionSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataLakeExceptionSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteDataLakeExceptionSubscription$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataLakeOrganizationConfigurationResponse deleteDataLakeOrganizationConfiguration(DeleteDataLakeOrganizationConfigurationRequest deleteDataLakeOrganizationConfigurationRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataLakeOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteDataLakeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataLakeOrganizationConfiguration");
            DeleteDataLakeOrganizationConfigurationResponse deleteDataLakeOrganizationConfigurationResponse = (DeleteDataLakeOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataLakeOrganizationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataLakeOrganizationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataLakeOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataLakeOrganizationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteDataLakeOrganizationConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubscriberResponse deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubscriber");
            DeleteSubscriberResponse deleteSubscriberResponse = (DeleteSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteSubscriber$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubscriberNotificationResponse deleteSubscriberNotification(DeleteSubscriberNotificationRequest deleteSubscriberNotificationRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSubscriberNotificationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deleteSubscriberNotificationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSubscriberNotification");
            DeleteSubscriberNotificationResponse deleteSubscriberNotificationResponse = (DeleteSubscriberNotificationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSubscriberNotification").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSubscriberNotificationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSubscriberNotificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSubscriberNotificationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deleteSubscriberNotification$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterDataLakeDelegatedAdministratorResponse deregisterDataLakeDelegatedAdministrator(DeregisterDataLakeDelegatedAdministratorRequest deregisterDataLakeDelegatedAdministratorRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterDataLakeDelegatedAdministratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, deregisterDataLakeDelegatedAdministratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterDataLakeDelegatedAdministrator");
            DeregisterDataLakeDelegatedAdministratorResponse deregisterDataLakeDelegatedAdministratorResponse = (DeregisterDataLakeDelegatedAdministratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterDataLakeDelegatedAdministrator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterDataLakeDelegatedAdministratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterDataLakeDelegatedAdministratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterDataLakeDelegatedAdministratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$deregisterDataLakeDelegatedAdministrator$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataLakeExceptionSubscriptionResponse getDataLakeExceptionSubscription(GetDataLakeExceptionSubscriptionRequest getDataLakeExceptionSubscriptionRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakeExceptionSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDataLakeExceptionSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataLakeExceptionSubscription");
            GetDataLakeExceptionSubscriptionResponse getDataLakeExceptionSubscriptionResponse = (GetDataLakeExceptionSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakeExceptionSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataLakeExceptionSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataLakeExceptionSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataLakeExceptionSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDataLakeExceptionSubscription$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataLakeOrganizationConfigurationResponse getDataLakeOrganizationConfiguration(GetDataLakeOrganizationConfigurationRequest getDataLakeOrganizationConfigurationRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakeOrganizationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDataLakeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataLakeOrganizationConfiguration");
            GetDataLakeOrganizationConfigurationResponse getDataLakeOrganizationConfigurationResponse = (GetDataLakeOrganizationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakeOrganizationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataLakeOrganizationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataLakeOrganizationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataLakeOrganizationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDataLakeOrganizationConfiguration$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataLakeSourcesResponse getDataLakeSources(GetDataLakeSourcesRequest getDataLakeSourcesRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakeSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getDataLakeSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataLakeSources");
            GetDataLakeSourcesResponse getDataLakeSourcesResponse = (GetDataLakeSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakeSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataLakeSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataLakeSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataLakeSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getDataLakeSources$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetDataLakeSourcesIterable getDataLakeSourcesPaginator(GetDataLakeSourcesRequest getDataLakeSourcesRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new GetDataLakeSourcesIterable(this, this.applyPaginatorUserAgent(getDataLakeSourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubscriberResponse getSubscriber(GetSubscriberRequest getSubscriberRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, getSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSubscriber");
            GetSubscriberResponse getSubscriberResponse = (GetSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$getSubscriber$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataLakeExceptionsResponse listDataLakeExceptions(ListDataLakeExceptionsRequest listDataLakeExceptionsRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataLakeExceptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, listDataLakeExceptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataLakeExceptions");
            ListDataLakeExceptionsResponse listDataLakeExceptionsResponse = (ListDataLakeExceptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataLakeExceptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataLakeExceptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataLakeExceptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataLakeExceptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$listDataLakeExceptions$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDataLakeExceptionsIterable listDataLakeExceptionsPaginator(ListDataLakeExceptionsRequest listDataLakeExceptionsRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new ListDataLakeExceptionsIterable(this, this.applyPaginatorUserAgent(listDataLakeExceptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataLakesResponse listDataLakes(ListDataLakesRequest listDataLakesRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataLakesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, listDataLakesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataLakes");
            ListDataLakesResponse listDataLakesResponse = (ListDataLakesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataLakes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataLakesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataLakesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataLakesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$listDataLakes$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLogSourcesResponse listLogSources(ListLogSourcesRequest listLogSourcesRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLogSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, listLogSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLogSources");
            ListLogSourcesResponse listLogSourcesResponse = (ListLogSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLogSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLogSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLogSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLogSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$listLogSources$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLogSourcesIterable listLogSourcesPaginator(ListLogSourcesRequest listLogSourcesRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new ListLogSourcesIterable(this, this.applyPaginatorUserAgent(listLogSourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscribersResponse listSubscribers(ListSubscribersRequest listSubscribersRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSubscribersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, listSubscribersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSubscribers");
            ListSubscribersResponse listSubscribersResponse = (ListSubscribersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSubscribers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSubscribersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSubscribersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSubscribersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$listSubscribers$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSubscribersIterable listSubscribersPaginator(ListSubscribersRequest listSubscribersRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        return new ListSubscribersIterable(this, this.applyPaginatorUserAgent(listSubscribersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDataLakeDelegatedAdministratorResponse registerDataLakeDelegatedAdministrator(RegisterDataLakeDelegatedAdministratorRequest registerDataLakeDelegatedAdministratorRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDataLakeDelegatedAdministratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, registerDataLakeDelegatedAdministratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterDataLakeDelegatedAdministrator");
            RegisterDataLakeDelegatedAdministratorResponse registerDataLakeDelegatedAdministratorResponse = (RegisterDataLakeDelegatedAdministratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDataLakeDelegatedAdministrator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerDataLakeDelegatedAdministratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterDataLakeDelegatedAdministratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerDataLakeDelegatedAdministratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$registerDataLakeDelegatedAdministrator$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataLakeResponse updateDataLake(UpdateDataLakeRequest updateDataLakeRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataLakeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateDataLakeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataLake");
            UpdateDataLakeResponse updateDataLakeResponse = (UpdateDataLakeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataLake").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataLakeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataLakeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataLakeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateDataLake$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataLakeExceptionSubscriptionResponse updateDataLakeExceptionSubscription(UpdateDataLakeExceptionSubscriptionRequest updateDataLakeExceptionSubscriptionRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataLakeExceptionSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateDataLakeExceptionSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataLakeExceptionSubscription");
            UpdateDataLakeExceptionSubscriptionResponse updateDataLakeExceptionSubscriptionResponse = (UpdateDataLakeExceptionSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataLakeExceptionSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataLakeExceptionSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataLakeExceptionSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataLakeExceptionSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateDataLakeExceptionSubscription$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubscriberResponse updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubscriberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateSubscriberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubscriber");
            UpdateSubscriberResponse updateSubscriberResponse = (UpdateSubscriberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubscriber").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSubscriberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSubscriberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSubscriberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateSubscriber$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSubscriberNotificationResponse updateSubscriberNotification(UpdateSubscriberNotificationRequest updateSubscriberNotificationRequest) throws BadRequestException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityLakeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSubscriberNotificationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSecurityLakeClient.resolveMetricPublishers(this.clientConfiguration, updateSubscriberNotificationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SecurityLake");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSubscriberNotification");
            UpdateSubscriberNotificationResponse updateSubscriberNotificationResponse = (UpdateSubscriberNotificationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSubscriberNotification").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSubscriberNotificationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSubscriberNotificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSubscriberNotificationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSecurityLakeClient.lambda$updateSubscriberNotification$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends SecurityLakeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.90").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SecurityLakeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "securitylake";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SecurityLakeException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final SecurityLakeServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSubscriberNotification$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSubscriber$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataLakeExceptionSubscription$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataLake$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerDataLakeDelegatedAdministrator$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSubscribers$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLogSources$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataLakes$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataLakeExceptions$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSubscriber$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataLakeSources$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataLakeOrganizationConfiguration$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataLakeExceptionSubscription$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterDataLakeDelegatedAdministrator$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubscriberNotification$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSubscriber$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataLakeOrganizationConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataLakeExceptionSubscription$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataLake$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomLogSource$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAwsLogSource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubscriberNotification$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSubscriber$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataLakeOrganizationConfiguration$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataLakeExceptionSubscription$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataLake$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomLogSource$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAwsLogSource$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

