/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AccountListCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAwsLogSourceResponse
extends SecurityLakeResponse
implements ToCopyableBuilder<Builder, DeleteAwsLogSourceResponse> {
    private static final SdkField<List<String>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failed").getter(DeleteAwsLogSourceResponse.getter(DeleteAwsLogSourceResponse::failed)).setter(DeleteAwsLogSourceResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("processing").getter(DeleteAwsLogSourceResponse.getter(DeleteAwsLogSourceResponse::processing)).setter(DeleteAwsLogSourceResponse.setter(Builder::processing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processing").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD, PROCESSING_FIELD));
    private final List<String> failed;
    private final List<String> processing;

    private DeleteAwsLogSourceResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.processing = builder.processing;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<String> failed() {
        return this.failed;
    }

    public final boolean hasProcessing() {
        return this.processing != null && !(this.processing instanceof SdkAutoConstructList);
    }

    public final List<String> processing() {
        return this.processing;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessing() ? this.processing() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAwsLogSourceResponse)) {
            return false;
        }
        DeleteAwsLogSourceResponse other = (DeleteAwsLogSourceResponse)((Object)obj);
        return this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed()) && this.hasProcessing() == other.hasProcessing() && Objects.equals(this.processing(), other.processing());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAwsLogSourceResponse").add("Failed", this.hasFailed() ? this.failed() : null).add("Processing", this.hasProcessing() ? this.processing() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "processing": {
                return Optional.ofNullable(clazz.cast(this.processing()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAwsLogSourceResponse, T> g) {
        return obj -> g.apply((DeleteAwsLogSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeResponse.BuilderImpl
    implements Builder {
        private List<String> failed = DefaultSdkAutoConstructList.getInstance();
        private List<String> processing = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAwsLogSourceResponse model) {
            super(model);
            this.failed(model.failed);
            this.processing(model.processing);
        }

        public final Collection<String> getFailed() {
            if (this.failed instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failed;
        }

        public final void setFailed(Collection<String> failed) {
            this.failed = AccountListCopier.copy(failed);
        }

        @Override
        public final Builder failed(Collection<String> failed) {
            this.failed = AccountListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(String ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        public final Collection<String> getProcessing() {
            if (this.processing instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processing;
        }

        public final void setProcessing(Collection<String> processing) {
            this.processing = AccountListCopier.copy(processing);
        }

        @Override
        public final Builder processing(Collection<String> processing) {
            this.processing = AccountListCopier.copy(processing);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processing(String ... processing) {
            this.processing(Arrays.asList(processing));
            return this;
        }

        @Override
        public DeleteAwsLogSourceResponse build() {
            return new DeleteAwsLogSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAwsLogSourceResponse> {
        public Builder failed(Collection<String> var1);

        public Builder failed(String ... var1);

        public Builder processing(Collection<String> var1);

        public Builder processing(String ... var1);
    }
}

