/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securitylake.model.AllDimensionsMapCopier;
import software.amazon.awssdk.services.securitylake.model.Dimension;
import software.amazon.awssdk.services.securitylake.model.DimensionSetCopier;
import software.amazon.awssdk.services.securitylake.model.InputSetCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.services.securitylake.model.TwoDimensionsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAwsLogSourceRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, DeleteAwsLogSourceRequest> {
    private static final SdkField<Map<String, Map<String, List<String>>>> DISABLE_ALL_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("disableAllDimensions").getter(DeleteAwsLogSourceRequest.getter(DeleteAwsLogSourceRequest::disableAllDimensions)).setter(DeleteAwsLogSourceRequest.setter(Builder::disableAllDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableAllDimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISABLE_SINGLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("disableSingleDimension").getter(DeleteAwsLogSourceRequest.getter(DeleteAwsLogSourceRequest::disableSingleDimension)).setter(DeleteAwsLogSourceRequest.setter(Builder::disableSingleDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableSingleDimension").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> DISABLE_TWO_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("disableTwoDimensions").getter(DeleteAwsLogSourceRequest.getter(DeleteAwsLogSourceRequest::disableTwoDimensions)).setter(DeleteAwsLogSourceRequest.setter(Builder::disableTwoDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableTwoDimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputOrder").getter(DeleteAwsLogSourceRequest.getter(DeleteAwsLogSourceRequest::inputOrderAsStrings)).setter(DeleteAwsLogSourceRequest.setter(Builder::inputOrderWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_ALL_DIMENSIONS_FIELD, DISABLE_SINGLE_DIMENSION_FIELD, DISABLE_TWO_DIMENSIONS_FIELD, INPUT_ORDER_FIELD));
    private final Map<String, Map<String, List<String>>> disableAllDimensions;
    private final List<String> disableSingleDimension;
    private final Map<String, List<String>> disableTwoDimensions;
    private final List<String> inputOrder;

    private DeleteAwsLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.disableAllDimensions = builder.disableAllDimensions;
        this.disableSingleDimension = builder.disableSingleDimension;
        this.disableTwoDimensions = builder.disableTwoDimensions;
        this.inputOrder = builder.inputOrder;
    }

    public final boolean hasDisableAllDimensions() {
        return this.disableAllDimensions != null && !(this.disableAllDimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, List<String>>> disableAllDimensions() {
        return this.disableAllDimensions;
    }

    public final boolean hasDisableSingleDimension() {
        return this.disableSingleDimension != null && !(this.disableSingleDimension instanceof SdkAutoConstructList);
    }

    public final List<String> disableSingleDimension() {
        return this.disableSingleDimension;
    }

    public final boolean hasDisableTwoDimensions() {
        return this.disableTwoDimensions != null && !(this.disableTwoDimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> disableTwoDimensions() {
        return this.disableTwoDimensions;
    }

    public final List<Dimension> inputOrder() {
        return DimensionSetCopier.copyStringToEnum(this.inputOrder);
    }

    public final boolean hasInputOrder() {
        return this.inputOrder != null && !(this.inputOrder instanceof SdkAutoConstructList);
    }

    public final List<String> inputOrderAsStrings() {
        return this.inputOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisableAllDimensions() ? this.disableAllDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisableSingleDimension() ? this.disableSingleDimension() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisableTwoDimensions() ? this.disableTwoDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputOrder() ? this.inputOrderAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAwsLogSourceRequest)) {
            return false;
        }
        DeleteAwsLogSourceRequest other = (DeleteAwsLogSourceRequest)((Object)obj);
        return this.hasDisableAllDimensions() == other.hasDisableAllDimensions() && Objects.equals(this.disableAllDimensions(), other.disableAllDimensions()) && this.hasDisableSingleDimension() == other.hasDisableSingleDimension() && Objects.equals(this.disableSingleDimension(), other.disableSingleDimension()) && this.hasDisableTwoDimensions() == other.hasDisableTwoDimensions() && Objects.equals(this.disableTwoDimensions(), other.disableTwoDimensions()) && this.hasInputOrder() == other.hasInputOrder() && Objects.equals(this.inputOrderAsStrings(), other.inputOrderAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAwsLogSourceRequest").add("DisableAllDimensions", this.hasDisableAllDimensions() ? this.disableAllDimensions() : null).add("DisableSingleDimension", this.hasDisableSingleDimension() ? this.disableSingleDimension() : null).add("DisableTwoDimensions", this.hasDisableTwoDimensions() ? this.disableTwoDimensions() : null).add("InputOrder", this.hasInputOrder() ? this.inputOrderAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "disableAllDimensions": {
                return Optional.ofNullable(clazz.cast(this.disableAllDimensions()));
            }
            case "disableSingleDimension": {
                return Optional.ofNullable(clazz.cast(this.disableSingleDimension()));
            }
            case "disableTwoDimensions": {
                return Optional.ofNullable(clazz.cast(this.disableTwoDimensions()));
            }
            case "inputOrder": {
                return Optional.ofNullable(clazz.cast(this.inputOrderAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAwsLogSourceRequest, T> g) {
        return obj -> g.apply((DeleteAwsLogSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private Map<String, Map<String, List<String>>> disableAllDimensions = DefaultSdkAutoConstructMap.getInstance();
        private List<String> disableSingleDimension = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> disableTwoDimensions = DefaultSdkAutoConstructMap.getInstance();
        private List<String> inputOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAwsLogSourceRequest model) {
            super(model);
            this.disableAllDimensions(model.disableAllDimensions);
            this.disableSingleDimension(model.disableSingleDimension);
            this.disableTwoDimensions(model.disableTwoDimensions);
            this.inputOrderWithStrings(model.inputOrder);
        }

        public final Map<String, ? extends Map<String, ? extends Collection<String>>> getDisableAllDimensions() {
            if (this.disableAllDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.disableAllDimensions;
        }

        public final void setDisableAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> disableAllDimensions) {
            this.disableAllDimensions = AllDimensionsMapCopier.copy(disableAllDimensions);
        }

        @Override
        public final Builder disableAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> disableAllDimensions) {
            this.disableAllDimensions = AllDimensionsMapCopier.copy(disableAllDimensions);
            return this;
        }

        public final Collection<String> getDisableSingleDimension() {
            if (this.disableSingleDimension instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disableSingleDimension;
        }

        public final void setDisableSingleDimension(Collection<String> disableSingleDimension) {
            this.disableSingleDimension = InputSetCopier.copy(disableSingleDimension);
        }

        @Override
        public final Builder disableSingleDimension(Collection<String> disableSingleDimension) {
            this.disableSingleDimension = InputSetCopier.copy(disableSingleDimension);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disableSingleDimension(String ... disableSingleDimension) {
            this.disableSingleDimension(Arrays.asList(disableSingleDimension));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getDisableTwoDimensions() {
            if (this.disableTwoDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.disableTwoDimensions;
        }

        public final void setDisableTwoDimensions(Map<String, ? extends Collection<String>> disableTwoDimensions) {
            this.disableTwoDimensions = TwoDimensionsMapCopier.copy(disableTwoDimensions);
        }

        @Override
        public final Builder disableTwoDimensions(Map<String, ? extends Collection<String>> disableTwoDimensions) {
            this.disableTwoDimensions = TwoDimensionsMapCopier.copy(disableTwoDimensions);
            return this;
        }

        public final Collection<String> getInputOrder() {
            if (this.inputOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputOrder;
        }

        public final void setInputOrder(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
        }

        @Override
        public final Builder inputOrderWithStrings(Collection<String> inputOrder) {
            this.inputOrder = DimensionSetCopier.copy(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrderWithStrings(String ... inputOrder) {
            this.inputOrderWithStrings(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public final Builder inputOrder(Collection<Dimension> inputOrder) {
            this.inputOrder = DimensionSetCopier.copyEnumToString(inputOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputOrder(Dimension ... inputOrder) {
            this.inputOrder(Arrays.asList(inputOrder));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAwsLogSourceRequest build() {
            return new DeleteAwsLogSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAwsLogSourceRequest> {
        public Builder disableAllDimensions(Map<String, ? extends Map<String, ? extends Collection<String>>> var1);

        public Builder disableSingleDimension(Collection<String> var1);

        public Builder disableSingleDimension(String ... var1);

        public Builder disableTwoDimensions(Map<String, ? extends Collection<String>> var1);

        public Builder inputOrderWithStrings(Collection<String> var1);

        public Builder inputOrderWithStrings(String ... var1);

        public Builder inputOrder(Collection<Dimension> var1);

        public Builder inputOrder(Dimension ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

