/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.HttpsMethod;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriptionNotificationConfigurationRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, CreateSubscriptionNotificationConfigurationRequest> {
    private static final SdkField<Boolean> CREATE_SQS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createSqs").getter(CreateSubscriptionNotificationConfigurationRequest.getter(CreateSubscriptionNotificationConfigurationRequest::createSqs)).setter(CreateSubscriptionNotificationConfigurationRequest.setter(Builder::createSqs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createSqs").build()}).build();
    private static final SdkField<String> HTTPS_API_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpsApiKeyName").getter(CreateSubscriptionNotificationConfigurationRequest.getter(CreateSubscriptionNotificationConfigurationRequest::httpsApiKeyName)).setter(CreateSubscriptionNotificationConfigurationRequest.setter(Builder::httpsApiKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsApiKeyName").build()}).build();
    private static final SdkField<String> HTTPS_API_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpsApiKeyValue").getter(CreateSubscriptionNotificationConfigurationRequest.getter(CreateSubscriptionNotificationConfigurationRequest::httpsApiKeyValue)).setter(CreateSubscriptionNotificationConfigurationRequest.setter(Builder::httpsApiKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsApiKeyValue").build()}).build();
    private static final SdkField<String> HTTPS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpsMethod").getter(CreateSubscriptionNotificationConfigurationRequest.getter(CreateSubscriptionNotificationConfigurationRequest::httpsMethodAsString)).setter(CreateSubscriptionNotificationConfigurationRequest.setter(Builder::httpsMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsMethod").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateSubscriptionNotificationConfigurationRequest.getter(CreateSubscriptionNotificationConfigurationRequest::roleArn)).setter(CreateSubscriptionNotificationConfigurationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionEndpoint").getter(CreateSubscriptionNotificationConfigurationRequest.getter(CreateSubscriptionNotificationConfigurationRequest::subscriptionEndpoint)).setter(CreateSubscriptionNotificationConfigurationRequest.setter(Builder::subscriptionEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionEndpoint").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionId").getter(CreateSubscriptionNotificationConfigurationRequest.getter(CreateSubscriptionNotificationConfigurationRequest::subscriptionId)).setter(CreateSubscriptionNotificationConfigurationRequest.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("subscriptionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_SQS_FIELD, HTTPS_API_KEY_NAME_FIELD, HTTPS_API_KEY_VALUE_FIELD, HTTPS_METHOD_FIELD, ROLE_ARN_FIELD, SUBSCRIPTION_ENDPOINT_FIELD, SUBSCRIPTION_ID_FIELD));
    private final Boolean createSqs;
    private final String httpsApiKeyName;
    private final String httpsApiKeyValue;
    private final String httpsMethod;
    private final String roleArn;
    private final String subscriptionEndpoint;
    private final String subscriptionId;

    private CreateSubscriptionNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.createSqs = builder.createSqs;
        this.httpsApiKeyName = builder.httpsApiKeyName;
        this.httpsApiKeyValue = builder.httpsApiKeyValue;
        this.httpsMethod = builder.httpsMethod;
        this.roleArn = builder.roleArn;
        this.subscriptionEndpoint = builder.subscriptionEndpoint;
        this.subscriptionId = builder.subscriptionId;
    }

    public final Boolean createSqs() {
        return this.createSqs;
    }

    public final String httpsApiKeyName() {
        return this.httpsApiKeyName;
    }

    public final String httpsApiKeyValue() {
        return this.httpsApiKeyValue;
    }

    public final HttpsMethod httpsMethod() {
        return HttpsMethod.fromValue(this.httpsMethod);
    }

    public final String httpsMethodAsString() {
        return this.httpsMethod;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String subscriptionEndpoint() {
        return this.subscriptionEndpoint;
    }

    public final String subscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createSqs());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsApiKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsApiKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionNotificationConfigurationRequest)) {
            return false;
        }
        CreateSubscriptionNotificationConfigurationRequest other = (CreateSubscriptionNotificationConfigurationRequest)((Object)obj);
        return Objects.equals(this.createSqs(), other.createSqs()) && Objects.equals(this.httpsApiKeyName(), other.httpsApiKeyName()) && Objects.equals(this.httpsApiKeyValue(), other.httpsApiKeyValue()) && Objects.equals(this.httpsMethodAsString(), other.httpsMethodAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.subscriptionEndpoint(), other.subscriptionEndpoint()) && Objects.equals(this.subscriptionId(), other.subscriptionId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubscriptionNotificationConfigurationRequest").add("CreateSqs", (Object)this.createSqs()).add("HttpsApiKeyName", (Object)this.httpsApiKeyName()).add("HttpsApiKeyValue", (Object)this.httpsApiKeyValue()).add("HttpsMethod", (Object)this.httpsMethodAsString()).add("RoleArn", (Object)this.roleArn()).add("SubscriptionEndpoint", (Object)this.subscriptionEndpoint()).add("SubscriptionId", (Object)this.subscriptionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createSqs": {
                return Optional.ofNullable(clazz.cast(this.createSqs()));
            }
            case "httpsApiKeyName": {
                return Optional.ofNullable(clazz.cast(this.httpsApiKeyName()));
            }
            case "httpsApiKeyValue": {
                return Optional.ofNullable(clazz.cast(this.httpsApiKeyValue()));
            }
            case "httpsMethod": {
                return Optional.ofNullable(clazz.cast(this.httpsMethodAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "subscriptionEndpoint": {
                return Optional.ofNullable(clazz.cast(this.subscriptionEndpoint()));
            }
            case "subscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionNotificationConfigurationRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionNotificationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private Boolean createSqs;
        private String httpsApiKeyName;
        private String httpsApiKeyValue;
        private String httpsMethod;
        private String roleArn;
        private String subscriptionEndpoint;
        private String subscriptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionNotificationConfigurationRequest model) {
            super(model);
            this.createSqs(model.createSqs);
            this.httpsApiKeyName(model.httpsApiKeyName);
            this.httpsApiKeyValue(model.httpsApiKeyValue);
            this.httpsMethod(model.httpsMethod);
            this.roleArn(model.roleArn);
            this.subscriptionEndpoint(model.subscriptionEndpoint);
            this.subscriptionId(model.subscriptionId);
        }

        public final Boolean getCreateSqs() {
            return this.createSqs;
        }

        public final void setCreateSqs(Boolean createSqs) {
            this.createSqs = createSqs;
        }

        @Override
        public final Builder createSqs(Boolean createSqs) {
            this.createSqs = createSqs;
            return this;
        }

        public final String getHttpsApiKeyName() {
            return this.httpsApiKeyName;
        }

        public final void setHttpsApiKeyName(String httpsApiKeyName) {
            this.httpsApiKeyName = httpsApiKeyName;
        }

        @Override
        public final Builder httpsApiKeyName(String httpsApiKeyName) {
            this.httpsApiKeyName = httpsApiKeyName;
            return this;
        }

        public final String getHttpsApiKeyValue() {
            return this.httpsApiKeyValue;
        }

        public final void setHttpsApiKeyValue(String httpsApiKeyValue) {
            this.httpsApiKeyValue = httpsApiKeyValue;
        }

        @Override
        public final Builder httpsApiKeyValue(String httpsApiKeyValue) {
            this.httpsApiKeyValue = httpsApiKeyValue;
            return this;
        }

        public final String getHttpsMethod() {
            return this.httpsMethod;
        }

        public final void setHttpsMethod(String httpsMethod) {
            this.httpsMethod = httpsMethod;
        }

        @Override
        public final Builder httpsMethod(String httpsMethod) {
            this.httpsMethod = httpsMethod;
            return this;
        }

        @Override
        public final Builder httpsMethod(HttpsMethod httpsMethod) {
            this.httpsMethod(httpsMethod == null ? null : httpsMethod.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSubscriptionEndpoint() {
            return this.subscriptionEndpoint;
        }

        public final void setSubscriptionEndpoint(String subscriptionEndpoint) {
            this.subscriptionEndpoint = subscriptionEndpoint;
        }

        @Override
        public final Builder subscriptionEndpoint(String subscriptionEndpoint) {
            this.subscriptionEndpoint = subscriptionEndpoint;
            return this;
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionNotificationConfigurationRequest build() {
            return new CreateSubscriptionNotificationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriptionNotificationConfigurationRequest> {
        public Builder createSqs(Boolean var1);

        public Builder httpsApiKeyName(String var1);

        public Builder httpsApiKeyValue(String var1);

        public Builder httpsMethod(String var1);

        public Builder httpsMethod(HttpsMethod var1);

        public Builder roleArn(String var1);

        public Builder subscriptionEndpoint(String var1);

        public Builder subscriptionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

