/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.InputSetCopier;
import software.amazon.awssdk.services.securitylake.model.SecurityLakeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatalakeStatusRequest
extends SecurityLakeRequest
implements ToCopyableBuilder<Builder, GetDatalakeStatusRequest> {
    private static final SdkField<List<String>> ACCOUNT_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountSet").getter(GetDatalakeStatusRequest.getter(GetDatalakeStatusRequest::accountSet)).setter(GetDatalakeStatusRequest.setter(Builder::accountSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_ACCOUNT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxAccountResults").getter(GetDatalakeStatusRequest.getter(GetDatalakeStatusRequest::maxAccountResults)).setter(GetDatalakeStatusRequest.setter(Builder::maxAccountResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAccountResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetDatalakeStatusRequest.getter(GetDatalakeStatusRequest::nextToken)).setter(GetDatalakeStatusRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SET_FIELD, MAX_ACCOUNT_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> accountSet;
    private final Integer maxAccountResults;
    private final String nextToken;

    private GetDatalakeStatusRequest(BuilderImpl builder) {
        super(builder);
        this.accountSet = builder.accountSet;
        this.maxAccountResults = builder.maxAccountResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountSet() {
        return this.accountSet != null && !(this.accountSet instanceof SdkAutoConstructList);
    }

    public final List<String> accountSet() {
        return this.accountSet;
    }

    public final Integer maxAccountResults() {
        return this.maxAccountResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountSet() ? this.accountSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAccountResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatalakeStatusRequest)) {
            return false;
        }
        GetDatalakeStatusRequest other = (GetDatalakeStatusRequest)((Object)obj);
        return this.hasAccountSet() == other.hasAccountSet() && Objects.equals(this.accountSet(), other.accountSet()) && Objects.equals(this.maxAccountResults(), other.maxAccountResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDatalakeStatusRequest").add("AccountSet", this.hasAccountSet() ? this.accountSet() : null).add("MaxAccountResults", (Object)this.maxAccountResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountSet": {
                return Optional.ofNullable(clazz.cast(this.accountSet()));
            }
            case "maxAccountResults": {
                return Optional.ofNullable(clazz.cast(this.maxAccountResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatalakeStatusRequest, T> g) {
        return obj -> g.apply((GetDatalakeStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityLakeRequest.BuilderImpl
    implements Builder {
        private List<String> accountSet = DefaultSdkAutoConstructList.getInstance();
        private Integer maxAccountResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatalakeStatusRequest model) {
            super(model);
            this.accountSet(model.accountSet);
            this.maxAccountResults(model.maxAccountResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAccountSet() {
            if (this.accountSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountSet;
        }

        public final void setAccountSet(Collection<String> accountSet) {
            this.accountSet = InputSetCopier.copy(accountSet);
        }

        @Override
        public final Builder accountSet(Collection<String> accountSet) {
            this.accountSet = InputSetCopier.copy(accountSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountSet(String ... accountSet) {
            this.accountSet(Arrays.asList(accountSet));
            return this;
        }

        public final Integer getMaxAccountResults() {
            return this.maxAccountResults;
        }

        public final void setMaxAccountResults(Integer maxAccountResults) {
            this.maxAccountResults = maxAccountResults;
        }

        @Override
        public final Builder maxAccountResults(Integer maxAccountResults) {
            this.maxAccountResults = maxAccountResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDatalakeStatusRequest build() {
            return new GetDatalakeStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatalakeStatusRequest> {
        public Builder accountSet(Collection<String> var1);

        public Builder accountSet(String ... var1);

        public Builder maxAccountResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

