/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeAsyncClient;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesRequest;
import software.amazon.awssdk.services.securitylake.model.ListLogSourcesResponse;

public class ListLogSourcesPublisher
implements SdkPublisher<ListLogSourcesResponse> {
    private final SecurityLakeAsyncClient client;
    private final ListLogSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLogSourcesPublisher(SecurityLakeAsyncClient client, ListLogSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLogSourcesPublisher(SecurityLakeAsyncClient client, ListLogSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLogSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLogSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map<String, Map<String, List<String>>>> regionSourceTypesAccountsList() {
        Function<ListLogSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.regionSourceTypesAccountsList() != null) {
                return response.regionSourceTypesAccountsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLogSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLogSourcesResponseFetcher
    implements AsyncPageFetcher<ListLogSourcesResponse> {
        private ListLogSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListLogSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLogSourcesResponse> nextPage(ListLogSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListLogSourcesPublisher.this.client.listLogSources(ListLogSourcesPublisher.this.firstRequest);
            }
            return ListLogSourcesPublisher.this.client.listLogSources((ListLogSourcesRequest)((Object)ListLogSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

