/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMembershipResponse extends SecurityIrResponse implements
        ToCopyableBuilder<GetMembershipResponse.Builder, GetMembershipResponse> {
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(GetMembershipResponse::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(GetMembershipResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(GetMembershipResponse::regionAsString)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> MEMBERSHIP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipName").getter(getter(GetMembershipResponse::membershipName))
            .setter(setter(Builder::membershipName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipName").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(GetMembershipResponse::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipStatus").getter(getter(GetMembershipResponse::membershipStatusAsString))
            .setter(setter(Builder::membershipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipStatus").build()).build();

    private static final SdkField<Instant> MEMBERSHIP_ACTIVATION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("membershipActivationTimestamp")
            .getter(getter(GetMembershipResponse::membershipActivationTimestamp))
            .setter(setter(Builder::membershipActivationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipActivationTimestamp")
                    .build()).build();

    private static final SdkField<Instant> MEMBERSHIP_DEACTIVATION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("membershipDeactivationTimestamp")
            .getter(getter(GetMembershipResponse::membershipDeactivationTimestamp))
            .setter(setter(Builder::membershipDeactivationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipDeactivationTimestamp")
                    .build()).build();

    private static final SdkField<String> CUSTOMER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerType").getter(getter(GetMembershipResponse::customerTypeAsString))
            .setter(setter(Builder::customerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerType").build()).build();

    private static final SdkField<Long> NUMBER_OF_ACCOUNTS_COVERED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfAccountsCovered").getter(getter(GetMembershipResponse::numberOfAccountsCovered))
            .setter(setter(Builder::numberOfAccountsCovered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAccountsCovered").build())
            .build();

    private static final SdkField<List<IncidentResponder>> INCIDENT_RESPONSE_TEAM_FIELD = SdkField
            .<List<IncidentResponder>> builder(MarshallingType.LIST)
            .memberName("incidentResponseTeam")
            .getter(getter(GetMembershipResponse::incidentResponseTeam))
            .setter(setter(Builder::incidentResponseTeam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentResponseTeam").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncidentResponder> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncidentResponder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OptInFeature>> OPT_IN_FEATURES_FIELD = SdkField
            .<List<OptInFeature>> builder(MarshallingType.LIST)
            .memberName("optInFeatures")
            .getter(getter(GetMembershipResponse::optInFeatures))
            .setter(setter(Builder::optInFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptInFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptInFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MembershipAccountsConfigurations> MEMBERSHIP_ACCOUNTS_CONFIGURATIONS_FIELD = SdkField
            .<MembershipAccountsConfigurations> builder(MarshallingType.SDK_POJO)
            .memberName("membershipAccountsConfigurations")
            .getter(getter(GetMembershipResponse::membershipAccountsConfigurations))
            .setter(setter(Builder::membershipAccountsConfigurations))
            .constructor(MembershipAccountsConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipAccountsConfigurations")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_ID_FIELD,
            ACCOUNT_ID_FIELD, REGION_FIELD, MEMBERSHIP_NAME_FIELD, MEMBERSHIP_ARN_FIELD, MEMBERSHIP_STATUS_FIELD,
            MEMBERSHIP_ACTIVATION_TIMESTAMP_FIELD, MEMBERSHIP_DEACTIVATION_TIMESTAMP_FIELD, CUSTOMER_TYPE_FIELD,
            NUMBER_OF_ACCOUNTS_COVERED_FIELD, INCIDENT_RESPONSE_TEAM_FIELD, OPT_IN_FEATURES_FIELD,
            MEMBERSHIP_ACCOUNTS_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipId;

    private final String accountId;

    private final String region;

    private final String membershipName;

    private final String membershipArn;

    private final String membershipStatus;

    private final Instant membershipActivationTimestamp;

    private final Instant membershipDeactivationTimestamp;

    private final String customerType;

    private final Long numberOfAccountsCovered;

    private final List<IncidentResponder> incidentResponseTeam;

    private final List<OptInFeature> optInFeatures;

    private final MembershipAccountsConfigurations membershipAccountsConfigurations;

    private GetMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.membershipId = builder.membershipId;
        this.accountId = builder.accountId;
        this.region = builder.region;
        this.membershipName = builder.membershipName;
        this.membershipArn = builder.membershipArn;
        this.membershipStatus = builder.membershipStatus;
        this.membershipActivationTimestamp = builder.membershipActivationTimestamp;
        this.membershipDeactivationTimestamp = builder.membershipDeactivationTimestamp;
        this.customerType = builder.customerType;
        this.numberOfAccountsCovered = builder.numberOfAccountsCovered;
        this.incidentResponseTeam = builder.incidentResponseTeam;
        this.optInFeatures = builder.optInFeatures;
        this.membershipAccountsConfigurations = builder.membershipAccountsConfigurations;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the queried membership ID.
     * </p>
     * 
     * @return Response element for GetMembership that provides the queried membership ID.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the account configured to manage the membership.
     * </p>
     * 
     * @return Response element for GetMembership that provides the account configured to manage the membership.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the region configured to manage the membership.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link AwsRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return Response element for GetMembership that provides the region configured to manage the membership.
     * @see AwsRegion
     */
    public final AwsRegion region() {
        return AwsRegion.fromValue(region);
    }

    /**
     * <p>
     * Response element for GetMembership that provides the region configured to manage the membership.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link AwsRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return Response element for GetMembership that provides the region configured to manage the membership.
     * @see AwsRegion
     */
    public final String regionAsString() {
        return region;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the configured membership name.
     * </p>
     * 
     * @return Response element for GetMembership that provides the configured membership name.
     */
    public final String membershipName() {
        return membershipName;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the membership ARN.
     * </p>
     * 
     * @return Response element for GetMembership that provides the membership ARN.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the current membership status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return Response element for GetMembership that provides the current membership status.
     * @see MembershipStatus
     */
    public final MembershipStatus membershipStatus() {
        return MembershipStatus.fromValue(membershipStatus);
    }

    /**
     * <p>
     * Response element for GetMembership that provides the current membership status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipStatus}
     * will return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipStatusAsString}.
     * </p>
     * 
     * @return Response element for GetMembership that provides the current membership status.
     * @see MembershipStatus
     */
    public final String membershipStatusAsString() {
        return membershipStatus;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the configured membership activation timestamp.
     * </p>
     * 
     * @return Response element for GetMembership that provides the configured membership activation timestamp.
     */
    public final Instant membershipActivationTimestamp() {
        return membershipActivationTimestamp;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the configured membership name deactivation timestamp.
     * </p>
     * 
     * @return Response element for GetMembership that provides the configured membership name deactivation timestamp.
     */
    public final Instant membershipDeactivationTimestamp() {
        return membershipDeactivationTimestamp;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the configured membership type. Options include
     * <code> Standalone | Organizations</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customerType} will
     * return {@link CustomerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #customerTypeAsString}.
     * </p>
     * 
     * @return Response element for GetMembership that provides the configured membership type. Options include
     *         <code> Standalone | Organizations</code>.
     * @see CustomerType
     */
    public final CustomerType customerType() {
        return CustomerType.fromValue(customerType);
    }

    /**
     * <p>
     * Response element for GetMembership that provides the configured membership type. Options include
     * <code> Standalone | Organizations</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customerType} will
     * return {@link CustomerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #customerTypeAsString}.
     * </p>
     * 
     * @return Response element for GetMembership that provides the configured membership type. Options include
     *         <code> Standalone | Organizations</code>.
     * @see CustomerType
     */
    public final String customerTypeAsString() {
        return customerType;
    }

    /**
     * <p>
     * Response element for GetMembership that provides the number of accounts in the membership.
     * </p>
     * 
     * @return Response element for GetMembership that provides the number of accounts in the membership.
     */
    public final Long numberOfAccountsCovered() {
        return numberOfAccountsCovered;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncidentResponseTeam property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncidentResponseTeam() {
        return incidentResponseTeam != null && !(incidentResponseTeam instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetMembership that provides the configured membership incident response team members.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncidentResponseTeam} method.
     * </p>
     * 
     * @return Response element for GetMembership that provides the configured membership incident response team
     *         members.
     */
    public final List<IncidentResponder> incidentResponseTeam() {
        return incidentResponseTeam;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptInFeatures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptInFeatures() {
        return optInFeatures != null && !(optInFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetMembership that provides the if opt-in features have been enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptInFeatures} method.
     * </p>
     * 
     * @return Response element for GetMembership that provides the if opt-in features have been enabled.
     */
    public final List<OptInFeature> optInFeatures() {
        return optInFeatures;
    }

    /**
     * <p>
     * The <code>membershipAccountsConfigurations</code> field contains the configuration details for member accounts
     * within the Amazon Web Services Organizations membership structure.
     * </p>
     * <p>
     * This field returns a structure containing information about:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Account configurations for member accounts
     * </p>
     * </li>
     * <li>
     * <p>
     * Membership settings and preferences
     * </p>
     * </li>
     * <li>
     * <p>
     * Account-level permissions and roles
     * </p>
     * </li>
     * </ul>
     * 
     * @return The <code>membershipAccountsConfigurations</code> field contains the configuration details for member
     *         accounts within the Amazon Web Services Organizations membership structure. </p>
     *         <p>
     *         This field returns a structure containing information about:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Account configurations for member accounts
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Membership settings and preferences
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Account-level permissions and roles
     *         </p>
     *         </li>
     */
    public final MembershipAccountsConfigurations membershipAccountsConfigurations() {
        return membershipAccountsConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(membershipName());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(membershipActivationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(membershipDeactivationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(customerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAccountsCovered());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncidentResponseTeam() ? incidentResponseTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptInFeatures() ? optInFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(membershipAccountsConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMembershipResponse)) {
            return false;
        }
        GetMembershipResponse other = (GetMembershipResponse) obj;
        return Objects.equals(membershipId(), other.membershipId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(regionAsString(), other.regionAsString())
                && Objects.equals(membershipName(), other.membershipName())
                && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(membershipStatusAsString(), other.membershipStatusAsString())
                && Objects.equals(membershipActivationTimestamp(), other.membershipActivationTimestamp())
                && Objects.equals(membershipDeactivationTimestamp(), other.membershipDeactivationTimestamp())
                && Objects.equals(customerTypeAsString(), other.customerTypeAsString())
                && Objects.equals(numberOfAccountsCovered(), other.numberOfAccountsCovered())
                && hasIncidentResponseTeam() == other.hasIncidentResponseTeam()
                && Objects.equals(incidentResponseTeam(), other.incidentResponseTeam())
                && hasOptInFeatures() == other.hasOptInFeatures() && Objects.equals(optInFeatures(), other.optInFeatures())
                && Objects.equals(membershipAccountsConfigurations(), other.membershipAccountsConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMembershipResponse").add("MembershipId", membershipId()).add("AccountId", accountId())
                .add("Region", regionAsString())
                .add("MembershipName", membershipName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MembershipArn", membershipArn()).add("MembershipStatus", membershipStatusAsString())
                .add("MembershipActivationTimestamp", membershipActivationTimestamp())
                .add("MembershipDeactivationTimestamp", membershipDeactivationTimestamp())
                .add("CustomerType", customerTypeAsString()).add("NumberOfAccountsCovered", numberOfAccountsCovered())
                .add("IncidentResponseTeam", hasIncidentResponseTeam() ? incidentResponseTeam() : null)
                .add("OptInFeatures", hasOptInFeatures() ? optInFeatures() : null)
                .add("MembershipAccountsConfigurations", membershipAccountsConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "membershipName":
            return Optional.ofNullable(clazz.cast(membershipName()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "membershipStatus":
            return Optional.ofNullable(clazz.cast(membershipStatusAsString()));
        case "membershipActivationTimestamp":
            return Optional.ofNullable(clazz.cast(membershipActivationTimestamp()));
        case "membershipDeactivationTimestamp":
            return Optional.ofNullable(clazz.cast(membershipDeactivationTimestamp()));
        case "customerType":
            return Optional.ofNullable(clazz.cast(customerTypeAsString()));
        case "numberOfAccountsCovered":
            return Optional.ofNullable(clazz.cast(numberOfAccountsCovered()));
        case "incidentResponseTeam":
            return Optional.ofNullable(clazz.cast(incidentResponseTeam()));
        case "optInFeatures":
            return Optional.ofNullable(clazz.cast(optInFeatures()));
        case "membershipAccountsConfigurations":
            return Optional.ofNullable(clazz.cast(membershipAccountsConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("region", REGION_FIELD);
        map.put("membershipName", MEMBERSHIP_NAME_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("membershipStatus", MEMBERSHIP_STATUS_FIELD);
        map.put("membershipActivationTimestamp", MEMBERSHIP_ACTIVATION_TIMESTAMP_FIELD);
        map.put("membershipDeactivationTimestamp", MEMBERSHIP_DEACTIVATION_TIMESTAMP_FIELD);
        map.put("customerType", CUSTOMER_TYPE_FIELD);
        map.put("numberOfAccountsCovered", NUMBER_OF_ACCOUNTS_COVERED_FIELD);
        map.put("incidentResponseTeam", INCIDENT_RESPONSE_TEAM_FIELD);
        map.put("optInFeatures", OPT_IN_FEATURES_FIELD);
        map.put("membershipAccountsConfigurations", MEMBERSHIP_ACCOUNTS_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMembershipResponse, T> g) {
        return obj -> g.apply((GetMembershipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityIrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMembershipResponse> {
        /**
         * <p>
         * Response element for GetMembership that provides the queried membership ID.
         * </p>
         * 
         * @param membershipId
         *        Response element for GetMembership that provides the queried membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * Response element for GetMembership that provides the account configured to manage the membership.
         * </p>
         * 
         * @param accountId
         *        Response element for GetMembership that provides the account configured to manage the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Response element for GetMembership that provides the region configured to manage the membership.
         * </p>
         * 
         * @param region
         *        Response element for GetMembership that provides the region configured to manage the membership.
         * @see AwsRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsRegion
         */
        Builder region(String region);

        /**
         * <p>
         * Response element for GetMembership that provides the region configured to manage the membership.
         * </p>
         * 
         * @param region
         *        Response element for GetMembership that provides the region configured to manage the membership.
         * @see AwsRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsRegion
         */
        Builder region(AwsRegion region);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership name.
         * </p>
         * 
         * @param membershipName
         *        Response element for GetMembership that provides the configured membership name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipName(String membershipName);

        /**
         * <p>
         * Response element for GetMembership that provides the membership ARN.
         * </p>
         * 
         * @param membershipArn
         *        Response element for GetMembership that provides the membership ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * Response element for GetMembership that provides the current membership status.
         * </p>
         * 
         * @param membershipStatus
         *        Response element for GetMembership that provides the current membership status.
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder membershipStatus(String membershipStatus);

        /**
         * <p>
         * Response element for GetMembership that provides the current membership status.
         * </p>
         * 
         * @param membershipStatus
         *        Response element for GetMembership that provides the current membership status.
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder membershipStatus(MembershipStatus membershipStatus);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership activation timestamp.
         * </p>
         * 
         * @param membershipActivationTimestamp
         *        Response element for GetMembership that provides the configured membership activation timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipActivationTimestamp(Instant membershipActivationTimestamp);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership name deactivation timestamp.
         * </p>
         * 
         * @param membershipDeactivationTimestamp
         *        Response element for GetMembership that provides the configured membership name deactivation
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipDeactivationTimestamp(Instant membershipDeactivationTimestamp);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership type. Options include
         * <code> Standalone | Organizations</code>.
         * </p>
         * 
         * @param customerType
         *        Response element for GetMembership that provides the configured membership type. Options include
         *        <code> Standalone | Organizations</code>.
         * @see CustomerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerType
         */
        Builder customerType(String customerType);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership type. Options include
         * <code> Standalone | Organizations</code>.
         * </p>
         * 
         * @param customerType
         *        Response element for GetMembership that provides the configured membership type. Options include
         *        <code> Standalone | Organizations</code>.
         * @see CustomerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerType
         */
        Builder customerType(CustomerType customerType);

        /**
         * <p>
         * Response element for GetMembership that provides the number of accounts in the membership.
         * </p>
         * 
         * @param numberOfAccountsCovered
         *        Response element for GetMembership that provides the number of accounts in the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAccountsCovered(Long numberOfAccountsCovered);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership incident response team members.
         * </p>
         * 
         * @param incidentResponseTeam
         *        Response element for GetMembership that provides the configured membership incident response team
         *        members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentResponseTeam(Collection<IncidentResponder> incidentResponseTeam);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership incident response team members.
         * </p>
         * 
         * @param incidentResponseTeam
         *        Response element for GetMembership that provides the configured membership incident response team
         *        members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentResponseTeam(IncidentResponder... incidentResponseTeam);

        /**
         * <p>
         * Response element for GetMembership that provides the configured membership incident response team members.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.IncidentResponder.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityir.model.IncidentResponder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.IncidentResponder.Builder#build()} is called
         * immediately and its result is passed to {@link #incidentResponseTeam(List<IncidentResponder>)}.
         * 
         * @param incidentResponseTeam
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.IncidentResponder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incidentResponseTeam(java.util.Collection<IncidentResponder>)
         */
        Builder incidentResponseTeam(Consumer<IncidentResponder.Builder>... incidentResponseTeam);

        /**
         * <p>
         * Response element for GetMembership that provides the if opt-in features have been enabled.
         * </p>
         * 
         * @param optInFeatures
         *        Response element for GetMembership that provides the if opt-in features have been enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInFeatures(Collection<OptInFeature> optInFeatures);

        /**
         * <p>
         * Response element for GetMembership that provides the if opt-in features have been enabled.
         * </p>
         * 
         * @param optInFeatures
         *        Response element for GetMembership that provides the if opt-in features have been enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInFeatures(OptInFeature... optInFeatures);

        /**
         * <p>
         * Response element for GetMembership that provides the if opt-in features have been enabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.OptInFeature.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityir.model.OptInFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.OptInFeature.Builder#build()} is called immediately
         * and its result is passed to {@link #optInFeatures(List<OptInFeature>)}.
         * 
         * @param optInFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.OptInFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optInFeatures(java.util.Collection<OptInFeature>)
         */
        Builder optInFeatures(Consumer<OptInFeature.Builder>... optInFeatures);

        /**
         * <p>
         * The <code>membershipAccountsConfigurations</code> field contains the configuration details for member
         * accounts within the Amazon Web Services Organizations membership structure.
         * </p>
         * <p>
         * This field returns a structure containing information about:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Account configurations for member accounts
         * </p>
         * </li>
         * <li>
         * <p>
         * Membership settings and preferences
         * </p>
         * </li>
         * <li>
         * <p>
         * Account-level permissions and roles
         * </p>
         * </li>
         * </ul>
         * 
         * @param membershipAccountsConfigurations
         *        The <code>membershipAccountsConfigurations</code> field contains the configuration details for member
         *        accounts within the Amazon Web Services Organizations membership structure. </p>
         *        <p>
         *        This field returns a structure containing information about:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Account configurations for member accounts
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Membership settings and preferences
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Account-level permissions and roles
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipAccountsConfigurations(MembershipAccountsConfigurations membershipAccountsConfigurations);

        /**
         * <p>
         * The <code>membershipAccountsConfigurations</code> field contains the configuration details for member
         * accounts within the Amazon Web Services Organizations membership structure.
         * </p>
         * <p>
         * This field returns a structure containing information about:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Account configurations for member accounts
         * </p>
         * </li>
         * <li>
         * <p>
         * Membership settings and preferences
         * </p>
         * </li>
         * <li>
         * <p>
         * Account-level permissions and roles
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link MembershipAccountsConfigurations.Builder}
         * avoiding the need to create one manually via {@link MembershipAccountsConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipAccountsConfigurations.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #membershipAccountsConfigurations(MembershipAccountsConfigurations)}.
         * 
         * @param membershipAccountsConfigurations
         *        a consumer that will call methods on {@link MembershipAccountsConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #membershipAccountsConfigurations(MembershipAccountsConfigurations)
         */
        default Builder membershipAccountsConfigurations(
                Consumer<MembershipAccountsConfigurations.Builder> membershipAccountsConfigurations) {
            return membershipAccountsConfigurations(MembershipAccountsConfigurations.builder()
                    .applyMutation(membershipAccountsConfigurations).build());
        }
    }

    static final class BuilderImpl extends SecurityIrResponse.BuilderImpl implements Builder {
        private String membershipId;

        private String accountId;

        private String region;

        private String membershipName;

        private String membershipArn;

        private String membershipStatus;

        private Instant membershipActivationTimestamp;

        private Instant membershipDeactivationTimestamp;

        private String customerType;

        private Long numberOfAccountsCovered;

        private List<IncidentResponder> incidentResponseTeam = DefaultSdkAutoConstructList.getInstance();

        private List<OptInFeature> optInFeatures = DefaultSdkAutoConstructList.getInstance();

        private MembershipAccountsConfigurations membershipAccountsConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMembershipResponse model) {
            super(model);
            membershipId(model.membershipId);
            accountId(model.accountId);
            region(model.region);
            membershipName(model.membershipName);
            membershipArn(model.membershipArn);
            membershipStatus(model.membershipStatus);
            membershipActivationTimestamp(model.membershipActivationTimestamp);
            membershipDeactivationTimestamp(model.membershipDeactivationTimestamp);
            customerType(model.customerType);
            numberOfAccountsCovered(model.numberOfAccountsCovered);
            incidentResponseTeam(model.incidentResponseTeam);
            optInFeatures(model.optInFeatures);
            membershipAccountsConfigurations(model.membershipAccountsConfigurations);
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(AwsRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final String getMembershipName() {
            return membershipName;
        }

        public final void setMembershipName(String membershipName) {
            this.membershipName = membershipName;
        }

        @Override
        public final Builder membershipName(String membershipName) {
            this.membershipName = membershipName;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getMembershipStatus() {
            return membershipStatus;
        }

        public final void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        @Override
        public final Builder membershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
            return this;
        }

        @Override
        public final Builder membershipStatus(MembershipStatus membershipStatus) {
            this.membershipStatus(membershipStatus == null ? null : membershipStatus.toString());
            return this;
        }

        public final Instant getMembershipActivationTimestamp() {
            return membershipActivationTimestamp;
        }

        public final void setMembershipActivationTimestamp(Instant membershipActivationTimestamp) {
            this.membershipActivationTimestamp = membershipActivationTimestamp;
        }

        @Override
        public final Builder membershipActivationTimestamp(Instant membershipActivationTimestamp) {
            this.membershipActivationTimestamp = membershipActivationTimestamp;
            return this;
        }

        public final Instant getMembershipDeactivationTimestamp() {
            return membershipDeactivationTimestamp;
        }

        public final void setMembershipDeactivationTimestamp(Instant membershipDeactivationTimestamp) {
            this.membershipDeactivationTimestamp = membershipDeactivationTimestamp;
        }

        @Override
        public final Builder membershipDeactivationTimestamp(Instant membershipDeactivationTimestamp) {
            this.membershipDeactivationTimestamp = membershipDeactivationTimestamp;
            return this;
        }

        public final String getCustomerType() {
            return customerType;
        }

        public final void setCustomerType(String customerType) {
            this.customerType = customerType;
        }

        @Override
        public final Builder customerType(String customerType) {
            this.customerType = customerType;
            return this;
        }

        @Override
        public final Builder customerType(CustomerType customerType) {
            this.customerType(customerType == null ? null : customerType.toString());
            return this;
        }

        public final Long getNumberOfAccountsCovered() {
            return numberOfAccountsCovered;
        }

        public final void setNumberOfAccountsCovered(Long numberOfAccountsCovered) {
            this.numberOfAccountsCovered = numberOfAccountsCovered;
        }

        @Override
        public final Builder numberOfAccountsCovered(Long numberOfAccountsCovered) {
            this.numberOfAccountsCovered = numberOfAccountsCovered;
            return this;
        }

        public final List<IncidentResponder.Builder> getIncidentResponseTeam() {
            List<IncidentResponder.Builder> result = IncidentResponseTeamCopier.copyToBuilder(this.incidentResponseTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidentResponseTeam(Collection<IncidentResponder.BuilderImpl> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copyFromBuilder(incidentResponseTeam);
        }

        @Override
        public final Builder incidentResponseTeam(Collection<IncidentResponder> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copy(incidentResponseTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(IncidentResponder... incidentResponseTeam) {
            incidentResponseTeam(Arrays.asList(incidentResponseTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(Consumer<IncidentResponder.Builder>... incidentResponseTeam) {
            incidentResponseTeam(Stream.of(incidentResponseTeam).map(c -> IncidentResponder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OptInFeature.Builder> getOptInFeatures() {
            List<OptInFeature.Builder> result = OptInFeaturesCopier.copyToBuilder(this.optInFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptInFeatures(Collection<OptInFeature.BuilderImpl> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copyFromBuilder(optInFeatures);
        }

        @Override
        public final Builder optInFeatures(Collection<OptInFeature> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copy(optInFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(OptInFeature... optInFeatures) {
            optInFeatures(Arrays.asList(optInFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(Consumer<OptInFeature.Builder>... optInFeatures) {
            optInFeatures(Stream.of(optInFeatures).map(c -> OptInFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MembershipAccountsConfigurations.Builder getMembershipAccountsConfigurations() {
            return membershipAccountsConfigurations != null ? membershipAccountsConfigurations.toBuilder() : null;
        }

        public final void setMembershipAccountsConfigurations(
                MembershipAccountsConfigurations.BuilderImpl membershipAccountsConfigurations) {
            this.membershipAccountsConfigurations = membershipAccountsConfigurations != null ? membershipAccountsConfigurations
                    .build() : null;
        }

        @Override
        public final Builder membershipAccountsConfigurations(MembershipAccountsConfigurations membershipAccountsConfigurations) {
            this.membershipAccountsConfigurations = membershipAccountsConfigurations;
            return this;
        }

        @Override
        public GetMembershipResponse build() {
            return new GetMembershipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
