/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.securityir.model.AccessDeniedException;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsRequest;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsResponse;
import software.amazon.awssdk.services.securityir.model.CancelMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CancelMembershipResponse;
import software.amazon.awssdk.services.securityir.model.CloseCaseRequest;
import software.amazon.awssdk.services.securityir.model.CloseCaseResponse;
import software.amazon.awssdk.services.securityir.model.ConflictException;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.CreateCaseRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseResponse;
import software.amazon.awssdk.services.securityir.model.CreateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CreateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseResponse;
import software.amazon.awssdk.services.securityir.model.GetMembershipRequest;
import software.amazon.awssdk.services.securityir.model.GetMembershipResponse;
import software.amazon.awssdk.services.securityir.model.InternalServerException;
import software.amazon.awssdk.services.securityir.model.InvalidTokenException;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse;
import software.amazon.awssdk.services.securityir.model.ListCasesRequest;
import software.amazon.awssdk.services.securityir.model.ListCasesResponse;
import software.amazon.awssdk.services.securityir.model.ListCommentsRequest;
import software.amazon.awssdk.services.securityir.model.ListCommentsResponse;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest;
import software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse;
import software.amazon.awssdk.services.securityir.model.ListMembershipsRequest;
import software.amazon.awssdk.services.securityir.model.ListMembershipsResponse;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityir.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securityir.model.SecurityIncidentResponseNotActiveException;
import software.amazon.awssdk.services.securityir.model.SecurityIrException;
import software.amazon.awssdk.services.securityir.model.SendFeedbackRequest;
import software.amazon.awssdk.services.securityir.model.SendFeedbackResponse;
import software.amazon.awssdk.services.securityir.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.securityir.model.TagResourceRequest;
import software.amazon.awssdk.services.securityir.model.TagResourceResponse;
import software.amazon.awssdk.services.securityir.model.ThrottlingException;
import software.amazon.awssdk.services.securityir.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityir.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusResponse;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeRequest;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeResponse;
import software.amazon.awssdk.services.securityir.model.ValidationException;
import software.amazon.awssdk.services.securityir.paginators.ListCaseEditsIterable;
import software.amazon.awssdk.services.securityir.paginators.ListCasesIterable;
import software.amazon.awssdk.services.securityir.paginators.ListCommentsIterable;
import software.amazon.awssdk.services.securityir.paginators.ListInvestigationsIterable;
import software.amazon.awssdk.services.securityir.paginators.ListMembershipsIterable;

/**
 * Service client for accessing Security Incident Response. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This guide documents the action and response elements for use of the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecurityIrClient extends AwsClient {
    String SERVICE_NAME = "security-ir";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "security-ir";

    /**
     * <p>
     * Provides information on whether the supplied account IDs are associated with a membership.
     * </p>
     * <note>
     * <p>
     * AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
     * <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>. Not
     * zero-prepending to 12 digits could result in errors.
     * </p>
     * </note>
     *
     * @param batchGetMemberAccountDetailsRequest
     * @return Result of the BatchGetMemberAccountDetails operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.BatchGetMemberAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/BatchGetMemberAccountDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMemberAccountDetailsResponse batchGetMemberAccountDetails(
            BatchGetMemberAccountDetailsRequest batchGetMemberAccountDetailsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information on whether the supplied account IDs are associated with a membership.
     * </p>
     * <note>
     * <p>
     * AWS account ID's may appear less than 12 characters and need to be zero-prepended. An example would be
     * <code>123123123</code> which is nine digits, and with zero-prepend would be <code>000123123123</code>. Not
     * zero-prepending to 12 digits could result in errors.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetMemberAccountDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetMemberAccountDetailsRequest#builder()}
     * </p>
     *
     * @param batchGetMemberAccountDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetMemberAccountDetails operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.BatchGetMemberAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/BatchGetMemberAccountDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetMemberAccountDetailsResponse batchGetMemberAccountDetails(
            Consumer<BatchGetMemberAccountDetailsRequest.Builder> batchGetMemberAccountDetailsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return batchGetMemberAccountDetails(BatchGetMemberAccountDetailsRequest.builder()
                .applyMutation(batchGetMemberAccountDetailsRequest).build());
    }

    /**
     * <p>
     * Cancels an existing membership.
     * </p>
     *
     * @param cancelMembershipRequest
     * @return Result of the CancelMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CancelMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CancelMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelMembershipResponse cancelMembership(CancelMembershipRequest cancelMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an existing membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link CancelMembershipRequest#builder()}
     * </p>
     *
     * @param cancelMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CancelMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the CancelMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CancelMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CancelMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelMembershipResponse cancelMembership(Consumer<CancelMembershipRequest.Builder> cancelMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return cancelMembership(CancelMembershipRequest.builder().applyMutation(cancelMembershipRequest).build());
    }

    /**
     * <p>
     * Closes an existing case.
     * </p>
     *
     * @param closeCaseRequest
     * @return Result of the CloseCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CloseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CloseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CloseCaseResponse closeCase(CloseCaseRequest closeCaseRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Closes an existing case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CloseCaseRequest#builder()}
     * </p>
     *
     * @param closeCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CloseCaseRequest.Builder} to create a request.
     * @return Result of the CloseCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CloseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CloseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CloseCaseResponse closeCase(Consumer<CloseCaseRequest.Builder> closeCaseRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return closeCase(CloseCaseRequest.builder().applyMutation(closeCaseRequest).build());
    }

    /**
     * <p>
     * Creates a new case.
     * </p>
     *
     * @param createCaseRequest
     * @return Result of the CreateCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCaseResponse createCase(CreateCaseRequest createCaseRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCaseRequest#builder()}
     * </p>
     *
     * @param createCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CreateCaseRequest.Builder} to create a request.
     * @return Result of the CreateCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCaseResponse createCase(Consumer<CreateCaseRequest.Builder> createCaseRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return createCase(CreateCaseRequest.builder().applyMutation(createCaseRequest).build());
    }

    /**
     * <p>
     * Adds a comment to an existing case.
     * </p>
     *
     * @param createCaseCommentRequest
     * @return Result of the CreateCaseComment operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCaseCommentResponse createCaseComment(CreateCaseCommentRequest createCaseCommentRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a comment to an existing case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCaseCommentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCaseCommentRequest#builder()}
     * </p>
     *
     * @param createCaseCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CreateCaseCommentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCaseComment operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCaseCommentResponse createCaseComment(Consumer<CreateCaseCommentRequest.Builder> createCaseCommentRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return createCaseComment(CreateCaseCommentRequest.builder().applyMutation(createCaseCommentRequest).build());
    }

    /**
     * <p>
     * Creates a new membership.
     * </p>
     *
     * @param createMembershipRequest
     * @return Result of the CreateMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMembershipResponse createMembership(CreateMembershipRequest createMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMembershipRequest#builder()}
     * </p>
     *
     * @param createMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.CreateMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMembershipResponse createMembership(Consumer<CreateMembershipRequest.Builder> createMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return createMembership(CreateMembershipRequest.builder().applyMutation(createMembershipRequest).build());
    }

    /**
     * <p>
     * Returns the attributes of a case.
     * </p>
     *
     * @param getCaseRequest
     * @return Result of the GetCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCaseResponse getCase(GetCaseRequest getCaseRequest) throws ServiceQuotaExceededException, AccessDeniedException,
            ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException,
            ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException,
            SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the attributes of a case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseRequest.Builder} avoiding the need to create
     * one manually via {@link GetCaseRequest#builder()}
     * </p>
     *
     * @param getCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetCaseRequest.Builder} to create a request.
     * @return Result of the GetCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCaseResponse getCase(Consumer<GetCaseRequest.Builder> getCaseRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        return getCase(GetCaseRequest.builder().applyMutation(getCaseRequest).build());
    }

    /**
     * <p>
     * Returns a Pre-Signed URL for uploading attachments into a case.
     * </p>
     *
     * @param getCaseAttachmentDownloadUrlRequest
     * @return Result of the GetCaseAttachmentDownloadUrl operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCaseAttachmentDownloadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentDownloadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCaseAttachmentDownloadUrlResponse getCaseAttachmentDownloadUrl(
            GetCaseAttachmentDownloadUrlRequest getCaseAttachmentDownloadUrlRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Pre-Signed URL for uploading attachments into a case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseAttachmentDownloadUrlRequest.Builder}
     * avoiding the need to create one manually via {@link GetCaseAttachmentDownloadUrlRequest#builder()}
     * </p>
     *
     * @param getCaseAttachmentDownloadUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlRequest.Builder} to
     *        create a request.
     * @return Result of the GetCaseAttachmentDownloadUrl operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCaseAttachmentDownloadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentDownloadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCaseAttachmentDownloadUrlResponse getCaseAttachmentDownloadUrl(
            Consumer<GetCaseAttachmentDownloadUrlRequest.Builder> getCaseAttachmentDownloadUrlRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return getCaseAttachmentDownloadUrl(GetCaseAttachmentDownloadUrlRequest.builder()
                .applyMutation(getCaseAttachmentDownloadUrlRequest).build());
    }

    /**
     * <p>
     * Uploads an attachment to a case.
     * </p>
     *
     * @param getCaseAttachmentUploadUrlRequest
     * @return Result of the GetCaseAttachmentUploadUrl operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCaseAttachmentUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCaseAttachmentUploadUrlResponse getCaseAttachmentUploadUrl(
            GetCaseAttachmentUploadUrlRequest getCaseAttachmentUploadUrlRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an attachment to a case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseAttachmentUploadUrlRequest.Builder} avoiding
     * the need to create one manually via {@link GetCaseAttachmentUploadUrlRequest#builder()}
     * </p>
     *
     * @param getCaseAttachmentUploadUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlRequest.Builder} to
     *        create a request.
     * @return Result of the GetCaseAttachmentUploadUrl operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCaseAttachmentUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCaseAttachmentUploadUrlResponse getCaseAttachmentUploadUrl(
            Consumer<GetCaseAttachmentUploadUrlRequest.Builder> getCaseAttachmentUploadUrlRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return getCaseAttachmentUploadUrl(GetCaseAttachmentUploadUrlRequest.builder()
                .applyMutation(getCaseAttachmentUploadUrlRequest).build());
    }

    /**
     * <p>
     * Returns the attributes of a membership.
     * </p>
     *
     * @param getMembershipRequest
     * @return Result of the GetMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembershipResponse getMembership(GetMembershipRequest getMembershipRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the attributes of a membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembershipRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembershipRequest#builder()}
     * </p>
     *
     * @param getMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.GetMembershipRequest.Builder} to create a request.
     * @return Result of the GetMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembershipResponse getMembership(Consumer<GetMembershipRequest.Builder> getMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return getMembership(GetMembershipRequest.builder().applyMutation(getMembershipRequest).build());
    }

    /**
     * <p>
     * Views the case history for edits made to a designated case.
     * </p>
     *
     * @param listCaseEditsRequest
     * @return Result of the ListCaseEdits operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCaseEditsResponse listCaseEdits(ListCaseEditsRequest listCaseEditsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Views the case history for edits made to a designated case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCaseEditsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCaseEditsRequest#builder()}
     * </p>
     *
     * @param listCaseEditsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest.Builder} to create a request.
     * @return Result of the ListCaseEdits operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCaseEditsResponse listCaseEdits(Consumer<ListCaseEditsRequest.Builder> listCaseEditsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listCaseEdits(ListCaseEditsRequest.builder().applyMutation(listCaseEditsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsIterable responses = client.listCaseEditsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListCaseEditsIterable responses = client
     *             .listCaseEditsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsIterable responses = client.listCaseEditsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation.</b>
     * </p>
     *
     * @param listCaseEditsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCaseEditsIterable listCaseEditsPaginator(ListCaseEditsRequest listCaseEditsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return new ListCaseEditsIterable(this, listCaseEditsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsIterable responses = client.listCaseEditsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListCaseEditsIterable responses = client
     *             .listCaseEditsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCaseEditsIterable responses = client.listCaseEditsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCaseEdits(software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCaseEditsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCaseEditsRequest#builder()}
     * </p>
     *
     * @param listCaseEditsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCaseEditsIterable listCaseEditsPaginator(Consumer<ListCaseEditsRequest.Builder> listCaseEditsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listCaseEditsPaginator(ListCaseEditsRequest.builder().applyMutation(listCaseEditsRequest).build());
    }

    /**
     * <p>
     * Lists all cases the requester has access to.
     * </p>
     *
     * @param listCasesRequest
     * @return Result of the ListCases operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCasesResponse listCases(ListCasesRequest listCasesRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all cases the requester has access to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListCasesRequest#builder()}
     * </p>
     *
     * @param listCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCasesRequest.Builder} to create a request.
     * @return Result of the ListCases operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCasesResponse listCases(Consumer<ListCasesRequest.Builder> listCasesRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listCases(ListCasesRequest.builder().applyMutation(listCasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesIterable responses = client.listCasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListCasesIterable responses = client.listCasesPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListCasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesIterable responses = client.listCasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)} operation.</b>
     * </p>
     *
     * @param listCasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCasesIterable listCasesPaginator(ListCasesRequest listCasesRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        return new ListCasesIterable(this, listCasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesIterable responses = client.listCasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListCasesIterable responses = client.listCasesPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListCasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCasesIterable responses = client.listCasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCases(software.amazon.awssdk.services.securityir.model.ListCasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListCasesRequest#builder()}
     * </p>
     *
     * @param listCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCasesIterable listCasesPaginator(Consumer<ListCasesRequest.Builder> listCasesRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listCasesPaginator(ListCasesRequest.builder().applyMutation(listCasesRequest).build());
    }

    /**
     * <p>
     * Returns comments for a designated case.
     * </p>
     *
     * @param listCommentsRequest
     * @return Result of the ListComments operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommentsResponse listComments(ListCommentsRequest listCommentsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns comments for a designated case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommentsRequest#builder()}
     * </p>
     *
     * @param listCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCommentsRequest.Builder} to create a request.
     * @return Result of the ListComments operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommentsResponse listComments(Consumer<ListCommentsRequest.Builder> listCommentsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listComments(ListCommentsRequest.builder().applyMutation(listCommentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsIterable responses = client.listCommentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListCommentsIterable responses = client.listCommentsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListCommentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsIterable responses = client.listCommentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)} operation.</b>
     * </p>
     *
     * @param listCommentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommentsIterable listCommentsPaginator(ListCommentsRequest listCommentsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return new ListCommentsIterable(this, listCommentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsIterable responses = client.listCommentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListCommentsIterable responses = client.listCommentsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListCommentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListCommentsIterable responses = client.listCommentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComments(software.amazon.awssdk.services.securityir.model.ListCommentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommentsRequest#builder()}
     * </p>
     *
     * @param listCommentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListCommentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommentsIterable listCommentsPaginator(Consumer<ListCommentsRequest.Builder> listCommentsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listCommentsPaginator(ListCommentsRequest.builder().applyMutation(listCommentsRequest).build());
    }

    /**
     * <p>
     * Investigation performed by an agent for a security incident...
     * </p>
     *
     * @param listInvestigationsRequest
     * @return Result of the ListInvestigations operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvestigationsResponse listInvestigations(ListInvestigationsRequest listInvestigationsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Investigation performed by an agent for a security incident...
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvestigationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvestigationsRequest#builder()}
     * </p>
     *
     * @param listInvestigationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInvestigations operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvestigationsResponse listInvestigations(Consumer<ListInvestigationsRequest.Builder> listInvestigationsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listInvestigations(ListInvestigationsRequest.builder().applyMutation(listInvestigationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsIterable responses = client.listInvestigationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListInvestigationsIterable responses = client
     *             .listInvestigationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsIterable responses = client.listInvestigationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvestigationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvestigationsIterable listInvestigationsPaginator(ListInvestigationsRequest listInvestigationsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return new ListInvestigationsIterable(this, listInvestigationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsIterable responses = client.listInvestigationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListInvestigationsIterable responses = client
     *             .listInvestigationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListInvestigationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListInvestigationsIterable responses = client.listInvestigationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvestigations(software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvestigationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvestigationsRequest#builder()}
     * </p>
     *
     * @param listInvestigationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListInvestigationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListInvestigations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListInvestigations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvestigationsIterable listInvestigationsPaginator(
            Consumer<ListInvestigationsRequest.Builder> listInvestigationsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        return listInvestigationsPaginator(ListInvestigationsRequest.builder().applyMutation(listInvestigationsRequest).build());
    }

    /**
     * <p>
     * Returns the memberships that the calling principal can access.
     * </p>
     *
     * @param listMembershipsRequest
     * @return Result of the ListMemberships operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsResponse listMemberships(ListMembershipsRequest listMembershipsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the memberships that the calling principal can access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMembershipsRequest#builder()}
     * </p>
     *
     * @param listMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListMembershipsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMemberships operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsResponse listMemberships(Consumer<ListMembershipsRequest.Builder> listMembershipsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listMemberships(ListMembershipsRequest.builder().applyMutation(listMembershipsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListMembershipsIterable responses = client
     *             .listMembershipsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListMembershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation.</b>
     * </p>
     *
     * @param listMembershipsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsIterable listMembershipsPaginator(ListMembershipsRequest listMembershipsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return new ListMembershipsIterable(this, listMembershipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityir.paginators.ListMembershipsIterable responses = client
     *             .listMembershipsPaginator(request);
     *     for (software.amazon.awssdk.services.securityir.model.ListMembershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityir.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberships(software.amazon.awssdk.services.securityir.model.ListMembershipsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMembershipsRequest#builder()}
     * </p>
     *
     * @param listMembershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListMembershipsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsIterable listMembershipsPaginator(Consumer<ListMembershipsRequest.Builder> listMembershipsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return listMembershipsPaginator(ListMembershipsRequest.builder().applyMutation(listMembershipsRequest).build());
    }

    /**
     * <p>
     * Returns currently configured tags on a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ConflictException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns currently configured tags on a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ResourceNotFoundException, ThrottlingException, ConflictException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Send feedback based on response investigation action
     * </p>
     *
     * @param sendFeedbackRequest
     * @return Result of the SendFeedback operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.SendFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/SendFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default SendFeedbackResponse sendFeedback(SendFeedbackRequest sendFeedbackRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send feedback based on response investigation action
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link SendFeedbackRequest#builder()}
     * </p>
     *
     * @param sendFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.SendFeedbackRequest.Builder} to create a request.
     * @return Result of the SendFeedback operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.SendFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/SendFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default SendFeedbackResponse sendFeedback(Consumer<SendFeedbackRequest.Builder> sendFeedbackRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return sendFeedback(SendFeedbackRequest.builder().applyMutation(sendFeedbackRequest).build());
    }

    /**
     * <p>
     * Adds a tag(s) to a designated resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ResourceNotFoundException, ThrottlingException, ConflictException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag(s) to a designated resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ConflictException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag(s) from a designate resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ResourceNotFoundException, ThrottlingException, ConflictException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag(s) from a designate resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ConflictException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing case.
     * </p>
     *
     * @param updateCaseRequest
     * @return Result of the UpdateCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCaseResponse updateCase(UpdateCaseRequest updateCaseRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaseRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCaseRequest#builder()}
     * </p>
     *
     * @param updateCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateCaseRequest.Builder} to create a request.
     * @return Result of the UpdateCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateCaseResponse updateCase(Consumer<UpdateCaseRequest.Builder> updateCaseRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return updateCase(UpdateCaseRequest.builder().applyMutation(updateCaseRequest).build());
    }

    /**
     * <p>
     * Updates an existing case comment.
     * </p>
     *
     * @param updateCaseCommentRequest
     * @return Result of the UpdateCaseComment operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCaseCommentResponse updateCaseComment(UpdateCaseCommentRequest updateCaseCommentRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing case comment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaseCommentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCaseCommentRequest#builder()}
     * </p>
     *
     * @param updateCaseCommentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateCaseCommentRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCaseComment operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCaseCommentResponse updateCaseComment(Consumer<UpdateCaseCommentRequest.Builder> updateCaseCommentRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return updateCaseComment(UpdateCaseCommentRequest.builder().applyMutation(updateCaseCommentRequest).build());
    }

    /**
     * <p>
     * Updates the state transitions for a designated cases.
     * </p>
     * <p>
     * <b>Self-managed</b>: the following states are available for self-managed cases.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Any → Closed
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>AWS supported</b>: You must use the <code>CloseCase</code> API to close.
     * </p>
     *
     * @param updateCaseStatusRequest
     * @return Result of the UpdateCaseStatus operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCaseStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCaseStatusResponse updateCaseStatus(UpdateCaseStatusRequest updateCaseStatusRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the state transitions for a designated cases.
     * </p>
     * <p>
     * <b>Self-managed</b>: the following states are available for self-managed cases.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Submitted → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Detection and Analysis → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Containment, Eradication, and Recovery → Post-incident Activities
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Containment, Eradication, and Recovery
     * </p>
     * </li>
     * <li>
     * <p>
     * Post-incident Activities → Detection and Analysis
     * </p>
     * </li>
     * <li>
     * <p>
     * Any → Closed
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>AWS supported</b>: You must use the <code>CloseCase</code> API to close.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaseStatusRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCaseStatusRequest#builder()}
     * </p>
     *
     * @param updateCaseStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateCaseStatusRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateCaseStatus operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCaseStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCaseStatusResponse updateCaseStatus(Consumer<UpdateCaseStatusRequest.Builder> updateCaseStatusRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return updateCaseStatus(UpdateCaseStatusRequest.builder().applyMutation(updateCaseStatusRequest).build());
    }

    /**
     * <p>
     * Updates membership configuration.
     * </p>
     *
     * @param updateMembershipRequest
     * @return Result of the UpdateMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateMembershipResponse updateMembership(UpdateMembershipRequest updateMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates membership configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMembershipRequest#builder()}
     * </p>
     *
     * @param updateMembershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateMembershipRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateMembershipResponse updateMembership(Consumer<UpdateMembershipRequest.Builder> updateMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return updateMembership(UpdateMembershipRequest.builder().applyMutation(updateMembershipRequest).build());
    }

    /**
     * <p>
     * Updates the resolver type for a case.
     * </p>
     * <important>
     * <p>
     * This is a one-way action and cannot be reversed.
     * </p>
     * </important>
     *
     * @param updateResolverTypeRequest
     * @return Result of the UpdateResolverType operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateResolverType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateResolverType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverTypeResponse updateResolverType(UpdateResolverTypeRequest updateResolverTypeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the resolver type for a case.
     * </p>
     * <important>
     * <p>
     * This is a one-way action and cannot be reversed.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverTypeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResolverTypeRequest#builder()}
     * </p>
     *
     * @param updateResolverTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityir.model.UpdateResolverTypeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResolverType operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateResolverType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateResolverType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverTypeResponse updateResolverType(Consumer<UpdateResolverTypeRequest.Builder> updateResolverTypeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        return updateResolverType(UpdateResolverTypeRequest.builder().applyMutation(updateResolverTypeRequest).build());
    }

    /**
     * Create a {@link SecurityIrClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityIrClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityIrClient}.
     */
    static SecurityIrClientBuilder builder() {
        return new DefaultSecurityIrClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SecurityIrServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
