/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionTarget> {
    private static final SdkField<String> ACTION_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionTarget.getter(ActionTarget::actionTargetArn)).setter(ActionTarget.setter(Builder::actionTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionTargetArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionTarget.getter(ActionTarget::name)).setter(ActionTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionTarget.getter(ActionTarget::description)).setter(ActionTarget.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TARGET_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionTargetArn;
    private final String name;
    private final String description;

    private ActionTarget(BuilderImpl builder) {
        this.actionTargetArn = builder.actionTargetArn;
        this.name = builder.name;
        this.description = builder.description;
    }

    public String actionTargetArn() {
        return this.actionTargetArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTarget)) {
            return false;
        }
        ActionTarget other = (ActionTarget)obj;
        return Objects.equals(this.actionTargetArn(), other.actionTargetArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"ActionTarget").add("ActionTargetArn", (Object)this.actionTargetArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionTargetArn": {
                return Optional.ofNullable(clazz.cast(this.actionTargetArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionTarget, T> g) {
        return obj -> g.apply((ActionTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionTargetArn;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTarget model) {
            this.actionTargetArn(model.actionTargetArn);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getActionTargetArn() {
            return this.actionTargetArn;
        }

        @Override
        public final Builder actionTargetArn(String actionTargetArn) {
            this.actionTargetArn = actionTargetArn;
            return this;
        }

        public final void setActionTargetArn(String actionTargetArn) {
            this.actionTargetArn = actionTargetArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public ActionTarget build() {
            return new ActionTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionTarget> {
        public Builder actionTargetArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);
    }
}

