/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.GranularityField;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsCopier;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsResult;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesTrendsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetResourcesTrendsV2Response> {
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Granularity").getter(GetResourcesTrendsV2Response.getter(GetResourcesTrendsV2Response::granularityAsString)).setter(GetResourcesTrendsV2Response.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final SdkField<List<ResourcesTrendsMetricsResult>> TRENDS_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrendsMetrics").getter(GetResourcesTrendsV2Response.getter(GetResourcesTrendsV2Response::trendsMetrics)).setter(GetResourcesTrendsV2Response.setter(Builder::trendsMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendsMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesTrendsMetricsResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetResourcesTrendsV2Response.getter(GetResourcesTrendsV2Response::nextToken)).setter(GetResourcesTrendsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANULARITY_FIELD, TRENDS_METRICS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourcesTrendsV2Response.memberNameToFieldInitializer();
    private final String granularity;
    private final List<ResourcesTrendsMetricsResult> trendsMetrics;
    private final String nextToken;

    private GetResourcesTrendsV2Response(BuilderImpl builder) {
        super(builder);
        this.granularity = builder.granularity;
        this.trendsMetrics = builder.trendsMetrics;
        this.nextToken = builder.nextToken;
    }

    public final GranularityField granularity() {
        return GranularityField.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final boolean hasTrendsMetrics() {
        return this.trendsMetrics != null && !(this.trendsMetrics instanceof SdkAutoConstructList);
    }

    public final List<ResourcesTrendsMetricsResult> trendsMetrics() {
        return this.trendsMetrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrendsMetrics() ? this.trendsMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesTrendsV2Response)) {
            return false;
        }
        GetResourcesTrendsV2Response other = (GetResourcesTrendsV2Response)((Object)obj);
        return Objects.equals(this.granularityAsString(), other.granularityAsString()) && this.hasTrendsMetrics() == other.hasTrendsMetrics() && Objects.equals(this.trendsMetrics(), other.trendsMetrics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcesTrendsV2Response").add("Granularity", (Object)this.granularityAsString()).add("TrendsMetrics", this.hasTrendsMetrics() ? this.trendsMetrics() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "TrendsMetrics": {
                return Optional.ofNullable(clazz.cast(this.trendsMetrics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("TrendsMetrics", TRENDS_METRICS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesTrendsV2Response, T> g) {
        return obj -> g.apply((GetResourcesTrendsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String granularity;
        private List<ResourcesTrendsMetricsResult> trendsMetrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesTrendsV2Response model) {
            super(model);
            this.granularity(model.granularity);
            this.trendsMetrics(model.trendsMetrics);
            this.nextToken(model.nextToken);
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(GranularityField granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final List<ResourcesTrendsMetricsResult.Builder> getTrendsMetrics() {
            List<ResourcesTrendsMetricsResult.Builder> result = ResourcesTrendsMetricsCopier.copyToBuilder(this.trendsMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrendsMetrics(Collection<ResourcesTrendsMetricsResult.BuilderImpl> trendsMetrics) {
            this.trendsMetrics = ResourcesTrendsMetricsCopier.copyFromBuilder(trendsMetrics);
        }

        @Override
        public final Builder trendsMetrics(Collection<ResourcesTrendsMetricsResult> trendsMetrics) {
            this.trendsMetrics = ResourcesTrendsMetricsCopier.copy(trendsMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendsMetrics(ResourcesTrendsMetricsResult ... trendsMetrics) {
            this.trendsMetrics(Arrays.asList(trendsMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trendsMetrics(Consumer<ResourcesTrendsMetricsResult.Builder> ... trendsMetrics) {
            this.trendsMetrics(Stream.of(trendsMetrics).map(c -> (ResourcesTrendsMetricsResult)((ResourcesTrendsMetricsResult.Builder)ResourcesTrendsMetricsResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourcesTrendsV2Response build() {
            return new GetResourcesTrendsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesTrendsV2Response> {
        public Builder granularity(String var1);

        public Builder granularity(GranularityField var1);

        public Builder trendsMetrics(Collection<ResourcesTrendsMetricsResult> var1);

        public Builder trendsMetrics(ResourcesTrendsMetricsResult ... var1);

        public Builder trendsMetrics(Consumer<ResourcesTrendsMetricsResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

