/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsMountPoint;
import software.amazon.awssdk.services.securityhub.model.AwsMountPointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsContainerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsContainerDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsEcsContainerDetails.getter(AwsEcsContainerDetails::name)).setter(AwsEcsContainerDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(AwsEcsContainerDetails.getter(AwsEcsContainerDetails::image)).setter(AwsEcsContainerDetails.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<List<AwsMountPoint>> MOUNT_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MountPoints").getter(AwsEcsContainerDetails.getter(AwsEcsContainerDetails::mountPoints)).setter(AwsEcsContainerDetails.setter(Builder::mountPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsMountPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Privileged").getter(AwsEcsContainerDetails.getter(AwsEcsContainerDetails::privileged)).setter(AwsEcsContainerDetails.setter(Builder::privileged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privileged").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_FIELD, MOUNT_POINTS_FIELD, PRIVILEGED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEcsContainerDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String image;
    private final List<AwsMountPoint> mountPoints;
    private final Boolean privileged;

    private AwsEcsContainerDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.image = builder.image;
        this.mountPoints = builder.mountPoints;
        this.privileged = builder.privileged;
    }

    public final String name() {
        return this.name;
    }

    public final String image() {
        return this.image;
    }

    public final boolean hasMountPoints() {
        return this.mountPoints != null && !(this.mountPoints instanceof SdkAutoConstructList);
    }

    public final List<AwsMountPoint> mountPoints() {
        return this.mountPoints;
    }

    public final Boolean privileged() {
        return this.privileged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMountPoints() ? this.mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsContainerDetails)) {
            return false;
        }
        AwsEcsContainerDetails other = (AwsEcsContainerDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.image(), other.image()) && this.hasMountPoints() == other.hasMountPoints() && Objects.equals(this.mountPoints(), other.mountPoints()) && Objects.equals(this.privileged(), other.privileged());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsContainerDetails").add("Name", (Object)this.name()).add("Image", (Object)this.image()).add("MountPoints", this.hasMountPoints() ? this.mountPoints() : null).add("Privileged", (Object)this.privileged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "MountPoints": {
                return Optional.ofNullable(clazz.cast(this.mountPoints()));
            }
            case "Privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("MountPoints", MOUNT_POINTS_FIELD);
        map.put("Privileged", PRIVILEGED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsContainerDetails, T> g) {
        return obj -> g.apply((AwsEcsContainerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String image;
        private List<AwsMountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();
        private Boolean privileged;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsContainerDetails model) {
            this.name(model.name);
            this.image(model.image);
            this.mountPoints(model.mountPoints);
            this.privileged(model.privileged);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final List<AwsMountPoint.Builder> getMountPoints() {
            List<AwsMountPoint.Builder> result = AwsMountPointListCopier.copyToBuilder(this.mountPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMountPoints(Collection<AwsMountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = AwsMountPointListCopier.copyFromBuilder(mountPoints);
        }

        @Override
        public final Builder mountPoints(Collection<AwsMountPoint> mountPoints) {
            this.mountPoints = AwsMountPointListCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(AwsMountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<AwsMountPoint.Builder> ... mountPoints) {
            this.mountPoints(Stream.of(mountPoints).map(c -> (AwsMountPoint)((AwsMountPoint.Builder)AwsMountPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public AwsEcsContainerDetails build() {
            return new AwsEcsContainerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsContainerDetails> {
        public Builder name(String var1);

        public Builder image(String var1);

        public Builder mountPoints(Collection<AwsMountPoint> var1);

        public Builder mountPoints(AwsMountPoint ... var1);

        public Builder mountPoints(Consumer<AwsMountPoint.Builder> ... var1);

        public Builder privileged(Boolean var1);
    }
}

