/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndex;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableReplicaGlobalSecondaryIndexListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsDynamoDbTableReplica
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsDynamoDbTableReplica> {
    private static final SdkField<List<AwsDynamoDbTableReplicaGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(AwsDynamoDbTableReplica.getter(AwsDynamoDbTableReplica::globalSecondaryIndexes)).setter(AwsDynamoDbTableReplica.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableReplicaGlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsMasterKeyId").getter(AwsDynamoDbTableReplica.getter(AwsDynamoDbTableReplica::kmsMasterKeyId)).setter(AwsDynamoDbTableReplica.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyId").build()}).build();
    private static final SdkField<AwsDynamoDbTableProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(AwsDynamoDbTableReplica.getter(AwsDynamoDbTableReplica::provisionedThroughputOverride)).setter(AwsDynamoDbTableReplica.setter(Builder::provisionedThroughputOverride)).constructor(AwsDynamoDbTableProvisionedThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(AwsDynamoDbTableReplica.getter(AwsDynamoDbTableReplica::regionName)).setter(AwsDynamoDbTableReplica.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatus").getter(AwsDynamoDbTableReplica.getter(AwsDynamoDbTableReplica::replicaStatus)).setter(AwsDynamoDbTableReplica.setter(Builder::replicaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatusDescription").getter(AwsDynamoDbTableReplica.getter(AwsDynamoDbTableReplica::replicaStatusDescription)).setter(AwsDynamoDbTableReplica.setter(Builder::replicaStatusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_SECONDARY_INDEXES_FIELD, KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, REGION_NAME_FIELD, REPLICA_STATUS_FIELD, REPLICA_STATUS_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsDynamoDbTableReplica.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes;
    private final String kmsMasterKeyId;
    private final AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride;
    private final String regionName;
    private final String replicaStatus;
    private final String replicaStatusDescription;

    private AwsDynamoDbTableReplica(BuilderImpl builder) {
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaStatusDescription = builder.replicaStatusDescription;
    }

    public final boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public final String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public final AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String replicaStatus() {
        return this.replicaStatus;
    }

    public final String replicaStatusDescription() {
        return this.replicaStatusDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableReplica)) {
            return false;
        }
        AwsDynamoDbTableReplica other = (AwsDynamoDbTableReplica)obj;
        return this.hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes() && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.replicaStatus(), other.replicaStatus()) && Objects.equals(this.replicaStatusDescription(), other.replicaStatusDescription());
    }

    public final String toString() {
        return ToString.builder((String)"AwsDynamoDbTableReplica").add("GlobalSecondaryIndexes", this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null).add("KmsMasterKeyId", (Object)this.kmsMasterKeyId()).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("RegionName", (Object)this.regionName()).add("ReplicaStatus", (Object)this.replicaStatus()).add("ReplicaStatusDescription", (Object)this.replicaStatusDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "KmsMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.replicaStatus()));
            }
            case "ReplicaStatusDescription": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlobalSecondaryIndexes", GLOBAL_SECONDARY_INDEXES_FIELD);
        map.put("KmsMasterKeyId", KMS_MASTER_KEY_ID_FIELD);
        map.put("ProvisionedThroughputOverride", PROVISIONED_THROUGHPUT_OVERRIDE_FIELD);
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("ReplicaStatus", REPLICA_STATUS_FIELD);
        map.put("ReplicaStatusDescription", REPLICA_STATUS_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableReplica, T> g) {
        return obj -> g.apply((AwsDynamoDbTableReplica)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private String kmsMasterKeyId;
        private AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride;
        private String regionName;
        private String replicaStatus;
        private String replicaStatusDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableReplica model) {
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.regionName(model.regionName);
            this.replicaStatus(model.replicaStatus);
            this.replicaStatusDescription(model.replicaStatusDescription);
        }

        public final List<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder> result = AwsDynamoDbTableReplicaGlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<AwsDynamoDbTableReplicaGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableReplicaGlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableReplicaGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableReplicaGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(AwsDynamoDbTableReplicaGlobalSecondaryIndex ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (AwsDynamoDbTableReplicaGlobalSecondaryIndex)((AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder)AwsDynamoDbTableReplicaGlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final AwsDynamoDbTableProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(AwsDynamoDbTableProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(AwsDynamoDbTableProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getReplicaStatus() {
            return this.replicaStatus;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        public final String getReplicaStatusDescription() {
            return this.replicaStatusDescription;
        }

        public final void setReplicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
        }

        @Override
        public final Builder replicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
            return this;
        }

        public AwsDynamoDbTableReplica build() {
            return new AwsDynamoDbTableReplica(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsDynamoDbTableReplica> {
        public Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableReplicaGlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexes(AwsDynamoDbTableReplicaGlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexes(Consumer<AwsDynamoDbTableReplicaGlobalSecondaryIndex.Builder> ... var1);

        public Builder kmsMasterKeyId(String var1);

        public Builder provisionedThroughputOverride(AwsDynamoDbTableProvisionedThroughputOverride var1);

        default public Builder provisionedThroughputOverride(Consumer<AwsDynamoDbTableProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((AwsDynamoDbTableProvisionedThroughputOverride)((AwsDynamoDbTableProvisionedThroughputOverride.Builder)AwsDynamoDbTableProvisionedThroughputOverride.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder regionName(String var1);

        public Builder replicaStatus(String var1);

        public Builder replicaStatusDescription(String var1);
    }
}

